/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.LinkedList;
import org.jivesoftware.smack.JmDNSPresenceDiscoverer;
import org.jivesoftware.smack.LLPresence;
import org.jivesoftware.smack.LLPresenceDiscoverer;
import org.jivesoftware.smack.LLService;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.Tuple;
import org.jmdns.JmDNS;
import org.jmdns.ServiceInfo;
import org.jmdns.ServiceNameListener;
import org.jmdns.impl.DNSCache;
import org.jmdns.impl.DNSEntry;
import org.jmdns.impl.JmDNSImpl;

public class JmDNSService
extends LLService
implements ServiceNameListener {
    static JmDNS jmdns = null;
    static JmDNSPresenceDiscoverer presenceDiscoverer = null;
    private ServiceInfo serviceInfo;
    static final String SERVICE_TYPE = "_presence._tcp.local.";

    private JmDNSService(LLPresence lLPresence, LLPresenceDiscoverer lLPresenceDiscoverer) {
        super(lLPresence, lLPresenceDiscoverer);
    }

    public static LLService create(LLPresence lLPresence) throws XMPPException {
        return JmDNSService.create(lLPresence, null);
    }

    public static LLService create(LLPresence lLPresence, InetAddress inetAddress) throws XMPPException {
        JmDNSService.initJmDNS(inetAddress);
        JmDNSPresenceDiscoverer jmDNSPresenceDiscoverer = new JmDNSPresenceDiscoverer();
        JmDNSService jmDNSService = new JmDNSService(lLPresence, jmDNSPresenceDiscoverer);
        return jmDNSService;
    }

    @Override
    public void close() {
        super.close();
        jmdns.close();
        jmdns = null;
    }

    private static void initJmDNS(InetAddress inetAddress) throws XMPPException {
        try {
            if (jmdns == null) {
                jmdns = inetAddress == null ? JmDNS.create() : JmDNS.create(inetAddress);
            }
        }
        catch (IOException iOException) {
            throw new XMPPException(iOException);
        }
    }

    @Override
    protected void updateText() {
        Hashtable hashtable = new Hashtable();
        for (Tuple<String, String> tuple : this.presence.toList()) {
            if (tuple.a == null || tuple.b == null) continue;
            hashtable.put(tuple.a, tuple.b);
        }
        this.serviceInfo.setText(hashtable);
    }

    @Override
    protected void registerService() throws XMPPException {
        Hashtable hashtable = new Hashtable();
        for (Tuple<String, String> object : this.presence.toList()) {
            if (object.a == null || object.b == null) continue;
            hashtable.put(object.a, object.b);
        }
        this.serviceInfo = ServiceInfo.create(SERVICE_TYPE, this.presence.getServiceName(), this.presence.getPort(), 0, 0, hashtable);
        this.serviceInfo.addServiceNameListener(this);
        try {
            String string = this.serviceInfo.getQualifiedName();
            jmdns.registerService(this.serviceInfo);
            this.presence.setServiceName(this.serviceInfo.getName());
            if (!string.equals(this.serviceInfo.getQualifiedName())) {
                JmDNSImpl jmDNSImpl = (JmDNSImpl)jmdns;
                LinkedList<Object> linkedList = new LinkedList<Object>();
                for (DNSCache.CacheNode cacheNode = jmDNSImpl.getCache().find(string); cacheNode != null; cacheNode = cacheNode.next()) {
                    DNSEntry dNSEntry = cacheNode.getValue();
                    if (dNSEntry == null) continue;
                    linkedList.add(dNSEntry);
                }
                for (DNSEntry dNSEntry : linkedList) {
                    jmDNSImpl.getCache().remove(dNSEntry);
                }
            }
        }
        catch (IOException iOException) {
            throw new XMPPException(iOException);
        }
    }

    @Override
    protected void reannounceService() throws XMPPException {
        try {
            jmdns.reannounceService(this.serviceInfo);
        }
        catch (IOException iOException) {
            throw new XMPPException("Exception occured when reannouncing mDNS presence.", iOException);
        }
    }

    @Override
    public void serviceNameChanged(String string, String string2) {
        try {
            super.serviceNameChanged(string, string2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void makeUnavailable() {
        jmdns.unregisterService(this.serviceInfo);
        this.serviceInfo = null;
    }

    @Override
    public void spam() {
        super.spam();
        System.out.println("Service name: " + this.serviceInfo.getName());
    }
}

