/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.LLMessageListener;
import org.jivesoftware.smack.LLPresence;
import org.jivesoftware.smack.LLService;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;

public class LLChat {
    private String serviceName;
    private LLService service;
    private Set<LLMessageListener> listeners = new CopyOnWriteArraySet<LLMessageListener>();
    private List<Message> messageQueue = new LinkedList<Message>();

    LLChat(LLService lLService, LLPresence lLPresence) throws XMPPException {
        this.service = lLService;
        this.serviceName = lLPresence.getServiceName();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliver(Message message) {
        Set<LLMessageListener> set = this.listeners;
        synchronized (set) {
            if (this.listeners.isEmpty()) {
                this.messageQueue.add(message);
            } else {
                for (LLMessageListener lLMessageListener : this.listeners) {
                    lLMessageListener.processMessage(this, message);
                }
            }
        }
    }

    public void sendMessage(Message message) throws XMPPException {
        message.setTo(this.serviceName);
        message.setType(Message.Type.chat);
        this.service.sendMessage(message);
    }

    public Message generateMessage(String string) {
        Message message = new Message(this.serviceName, Message.Type.chat);
        message.setBody(string);
        return message;
    }

    public void sendMessage(String string) throws XMPPException {
        this.service.sendMessage(this.generateMessage(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(LLMessageListener lLMessageListener) {
        Set<LLMessageListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(lLMessageListener);
            for (Message message : this.messageQueue) {
                lLMessageListener.processMessage(this, message);
            }
            this.messageQueue.clear();
        }
    }
}

