/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.LLPresence;
import org.jivesoftware.smack.LLPresenceListener;

public abstract class LLPresenceDiscoverer {
    protected Set<LLPresenceListener> listeners = new CopyOnWriteArraySet<LLPresenceListener>();
    private Map<String, LLPresence> presences = new ConcurrentHashMap<String, LLPresence>();

    public void addPresenceListener(LLPresenceListener lLPresenceListener) {
        this.listeners.add(lLPresenceListener);
        for (LLPresence lLPresence : this.presences.values()) {
            lLPresenceListener.presenceNew(lLPresence);
        }
    }

    public void removePresenceListener(LLPresenceListener lLPresenceListener) {
        this.listeners.remove(lLPresenceListener);
    }

    public Collection<LLPresence> getPresences() {
        return this.presences.values();
    }

    public LLPresence getPresence(String string) {
        return this.presences.get(string);
    }

    protected void presenceAdded(String string) {
        this.presences.put(string, null);
    }

    protected void presenceInfoAdded(String string, LLPresence lLPresence) {
        lLPresence.updateFrom(this.presences.get(string));
        this.presences.put(string, lLPresence);
        for (LLPresenceListener lLPresenceListener : this.listeners) {
            lLPresenceListener.presenceNew(lLPresence);
        }
    }

    protected void presenceRemoved(String string) {
        LLPresence lLPresence = this.presences.remove(string);
        for (LLPresenceListener lLPresenceListener : this.listeners) {
            lLPresenceListener.presenceRemove(lLPresence);
        }
    }
}

