/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.LLChat;
import org.jivesoftware.smack.LLChatListener;
import org.jivesoftware.smack.LLConnectionConfiguration;
import org.jivesoftware.smack.LLConnectionListener;
import org.jivesoftware.smack.LLPresence;
import org.jivesoftware.smack.LLPresenceDiscoverer;
import org.jivesoftware.smack.LLPresenceListener;
import org.jivesoftware.smack.LLServiceConnectionListener;
import org.jivesoftware.smack.LLServiceListener;
import org.jivesoftware.smack.LLServiceStateListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.XMPPLLConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;

public abstract class LLService {
    private LLService service = null;
    private static Set<LLServiceListener> serviceCreatedListeners = new CopyOnWriteArraySet<LLServiceListener>();
    static final int DEFAULT_MIN_PORT = 2300;
    static final int DEFAULT_MAX_PORT = 2400;
    protected LLPresence presence;
    private boolean done = false;
    private Thread listenerThread;
    private boolean initiated = false;
    private Map<String, LLChat> chats = new ConcurrentHashMap<String, LLChat>();
    private Map<String, XMPPLLConnection> ingoing = new ConcurrentHashMap<String, XMPPLLConnection>();
    private Map<String, XMPPLLConnection> outgoing = new ConcurrentHashMap<String, XMPPLLConnection>();
    private Set<LLServiceStateListener> stateListeners = new CopyOnWriteArraySet<LLServiceStateListener>();
    private Set<LLServiceConnectionListener> llServiceConnectionListeners = new CopyOnWriteArraySet<LLServiceConnectionListener>();
    private final Map<PacketListener, ListenerWrapper> listeners = new ConcurrentHashMap<PacketListener, ListenerWrapper>();
    private LLPresenceDiscoverer presenceDiscoverer;
    private Set<LLChatListener> chatListeners = new CopyOnWriteArraySet<LLChatListener>();
    private Set<CollectorWrapper> collectorWrappers = new CopyOnWriteArraySet<CollectorWrapper>();
    private Set<XMPPLLConnection> associatedConnections = new HashSet<XMPPLLConnection>();
    private ServerSocket socket;

    public void spam() {
        System.out.println("Number of ingoing connection in map: " + this.ingoing.size());
        System.out.println("Number of outgoing connection in map: " + this.outgoing.size());
        System.out.println("Active chats:");
        for (LLChat object : this.chats.values()) {
            System.out.println(" * " + object.getServiceName());
        }
        System.out.println("Known presences:");
        for (LLPresence lLPresence : this.presenceDiscoverer.getPresences()) {
            System.out.println(" * " + lLPresence.getServiceName() + "(" + (Object)((Object)lLPresence.getStatus()) + ", " + lLPresence.getHost() + ":" + lLPresence.getPort() + ")");
        }
        Thread.currentThread().getThreadGroup().list();
    }

    protected LLService(LLPresence lLPresence, LLPresenceDiscoverer lLPresenceDiscoverer) {
        this.presence = lLPresence;
        this.presenceDiscoverer = lLPresenceDiscoverer;
        this.service = this;
        XMPPLLConnection.addLLConnectionListener(new LLConnectionListener(){

            @Override
            public void connectionCreated(XMPPLLConnection xMPPLLConnection) {
                if (LLService.this.isAssociatedConnection(xMPPLLConnection)) {
                    if (xMPPLLConnection.isInitiator()) {
                        LLService.this.addOutgoingConnection(xMPPLLConnection);
                    } else {
                        LLService.this.addIngoingConnection(xMPPLLConnection);
                    }
                    xMPPLLConnection.addConnectionListener(new ConnectionActivityListener(xMPPLLConnection));
                    LLService.this.notifyNewServiceConnection(xMPPLLConnection);
                    xMPPLLConnection.addPacketListener(new MessageListener(), new AndFilter(new PacketTypeFilter(Message.class), new OrFilter(new MessageTypeFilter(Message.Type.chat), new OrFilter(new MessageTypeFilter(Message.Type.normal), new MessageTypeFilter(Message.Type.error)))));
                    for (Object object : LLService.this.listeners.values()) {
                        xMPPLLConnection.addPacketListener(((ListenerWrapper)object).getPacketListener(), ((ListenerWrapper)object).getPacketFilter());
                    }
                    for (Object object : LLService.this.collectorWrappers) {
                        ((CollectorWrapper)object).createPacketCollector(xMPPLLConnection);
                    }
                }
            }
        });
        LLService.notifyServiceListeners(this);
    }

    public static void addLLServiceListener(LLServiceListener lLServiceListener) {
        serviceCreatedListeners.add(lLServiceListener);
    }

    public static void removeLLServiceListener(LLServiceListener lLServiceListener) {
        serviceCreatedListeners.remove(lLServiceListener);
    }

    public static void notifyServiceListeners(LLService lLService) {
        for (LLServiceListener lLServiceListener : serviceCreatedListeners) {
            lLServiceListener.serviceCreated(lLService);
        }
    }

    protected abstract void registerService() throws XMPPException;

    protected abstract void reannounceService() throws XMPPException;

    public abstract void makeUnavailable();

    protected abstract void updateText();

    public void init() throws XMPPException {
        this.socket = LLService.bindRange(2300, 2400);
        this.presence.setPort(this.socket.getLocalPort());
        this.registerService();
        this.listenerThread = new Thread(){

            @Override
            public void run() {
                try {
                    LLService.this.listenForConnections();
                    for (LLServiceStateListener lLServiceStateListener : LLService.this.stateListeners) {
                        lLServiceStateListener.serviceClosed();
                    }
                }
                catch (XMPPException xMPPException) {
                    for (LLServiceStateListener lLServiceStateListener : LLService.this.stateListeners) {
                        lLServiceStateListener.serviceClosedOnError(xMPPException);
                    }
                }
            }
        };
        this.listenerThread.setName("Smack Link-local Service Listener");
        this.listenerThread.setDaemon(true);
        this.listenerThread.start();
        this.initiated = true;
    }

    public void close() {
        this.done = true;
        for (XMPPLLConnection xMPPLLConnection : this.ingoing.values()) {
            try {
                xMPPLLConnection.shutdown();
            }
            catch (Exception exception) {}
        }
        for (XMPPLLConnection xMPPLLConnection : this.outgoing.values()) {
            try {
                xMPPLLConnection.shutdown();
            }
            catch (Exception exception) {}
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void listenForConnections() throws XMPPException {
        while (!this.done) {
            try {
                Socket socket = this.socket.accept();
                LLConnectionConfiguration lLConnectionConfiguration = new LLConnectionConfiguration(this.presence, socket);
                XMPPLLConnection xMPPLLConnection = new XMPPLLConnection(this, lLConnectionConfiguration);
                this.addAssociatedConnection(xMPPLLConnection);
                ConnectionInitiatorThread connectionInitiatorThread = new ConnectionInitiatorThread(xMPPLLConnection);
                connectionInitiatorThread.setName("Smack Link-local Connection Initiator");
                connectionInitiatorThread.setDaemon(true);
                connectionInitiatorThread.start();
            }
            catch (SocketException socketException) {
                if (this.done) continue;
                throw new XMPPException("Link-local service unexpectedly closed down.", socketException);
            }
            catch (IOException iOException) {
                throw new XMPPException("Link-local service unexpectedly closed down.", iOException);
            }
        }
    }

    private static ServerSocket bindRange(int n, int n2) throws XMPPException {
        boolean bl = false;
        for (int i = n; i <= n2; ++i) {
            try {
                ServerSocket serverSocket = new ServerSocket(i);
                return serverSocket;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        throw new XMPPException("Unable to bind port, no ports available.");
    }

    protected void unknownOriginMessage(Message message) {
        for (LLServiceStateListener lLServiceStateListener : this.stateListeners) {
            lLServiceStateListener.unknownOriginMessage(message);
        }
    }

    protected void serviceNameChanged(String string, String string2) {
        this.presence.setServiceName(string);
        LLChat lLChat = this.removeLLChat(string);
        LLChat lLChat2 = this.removeLLChat(string2);
        for (LLChatListener object : this.chatListeners) {
            if (lLChat != null) {
                object.chatInvalidated(lLChat);
            }
            if (lLChat2 == null) continue;
            object.chatInvalidated(lLChat);
        }
        Object object = this.getConnectionTo(string2);
        if (object != null) {
            ((XMPPLLConnection)object).disconnect();
        }
        if ((object = this.getConnectionTo(string)) != null) {
            ((XMPPLLConnection)object).disconnect();
        }
        for (LLServiceStateListener lLServiceStateListener : this.stateListeners) {
            lLServiceStateListener.serviceNameChanged(string, string2);
        }
    }

    public void addLLServiceConnectionListener(LLServiceConnectionListener lLServiceConnectionListener) {
        this.llServiceConnectionListeners.add(lLServiceConnectionListener);
    }

    public void removeLLServiceConnectionListener(LLServiceConnectionListener lLServiceConnectionListener) {
        this.llServiceConnectionListeners.remove(lLServiceConnectionListener);
    }

    private void notifyNewServiceConnection(XMPPLLConnection xMPPLLConnection) {
        for (LLServiceConnectionListener lLServiceConnectionListener : this.llServiceConnectionListeners) {
            lLServiceConnectionListener.connectionCreated(xMPPLLConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAssociatedConnection(XMPPLLConnection xMPPLLConnection) {
        Set<XMPPLLConnection> set = this.associatedConnections;
        synchronized (set) {
            this.associatedConnections.add(xMPPLLConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAssociatedConnection(XMPPLLConnection xMPPLLConnection) {
        Set<XMPPLLConnection> set = this.associatedConnections;
        synchronized (set) {
            this.associatedConnections.remove(xMPPLLConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAssociatedConnection(XMPPLLConnection xMPPLLConnection) {
        Set<XMPPLLConnection> set = this.associatedConnections;
        synchronized (set) {
            return this.associatedConnections.contains(xMPPLLConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacketListener(PacketListener packetListener, PacketFilter packetFilter) {
        ListenerWrapper listenerWrapper = new ListenerWrapper(packetListener, packetFilter);
        this.listeners.put(packetListener, listenerWrapper);
        Map<String, XMPPLLConnection> map = this.ingoing;
        synchronized (map) {
            Map<String, XMPPLLConnection> map2 = this.outgoing;
            synchronized (map2) {
                for (XMPPLLConnection xMPPLLConnection : this.getConnections()) {
                    xMPPLLConnection.addPacketListener(packetListener, packetFilter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePacketListener(PacketListener packetListener) {
        this.listeners.remove(packetListener);
        Map<String, XMPPLLConnection> map = this.ingoing;
        synchronized (map) {
            Map<String, XMPPLLConnection> map2 = this.outgoing;
            synchronized (map2) {
                for (XMPPLLConnection xMPPLLConnection : this.getConnections()) {
                    xMPPLLConnection.removePacketListener(packetListener);
                }
            }
        }
    }

    public void addServiceStateListener(LLServiceStateListener lLServiceStateListener) {
        this.stateListeners.add(lLServiceStateListener);
    }

    public void removeServiceStateListener(LLServiceStateListener lLServiceStateListener) {
        this.stateListeners.remove(lLServiceStateListener);
    }

    public void addLLChatListener(LLChatListener lLChatListener) {
        this.chatListeners.add(lLChatListener);
    }

    public void removeLLChatListener(LLChatListener lLChatListener) {
        this.chatListeners.remove(lLChatListener);
    }

    public void addPresenceListener(LLPresenceListener lLPresenceListener) {
        this.presenceDiscoverer.addPresenceListener(lLPresenceListener);
    }

    public void removePresenceListener(LLPresenceListener lLPresenceListener) {
        this.presenceDiscoverer.removePresenceListener(lLPresenceListener);
    }

    public LLPresence getPresenceByServiceName(String string) {
        return this.presenceDiscoverer.getPresence(string);
    }

    public CollectorWrapper createPacketCollector(PacketFilter packetFilter) {
        CollectorWrapper collectorWrapper = new CollectorWrapper(packetFilter);
        this.collectorWrappers.add(collectorWrapper);
        return collectorWrapper;
    }

    public Collection<XMPPLLConnection> getConnections() {
        ArrayList<XMPPLLConnection> arrayList = new ArrayList<XMPPLLConnection>(this.outgoing.values());
        arrayList.addAll(this.ingoing.values());
        return arrayList;
    }

    XMPPLLConnection getConnectionTo(String string) {
        XMPPLLConnection xMPPLLConnection = this.outgoing.get(string);
        if (xMPPLLConnection != null) {
            return xMPPLLConnection;
        }
        return this.ingoing.get(string);
    }

    void addIngoingConnection(XMPPLLConnection xMPPLLConnection) {
        this.ingoing.put(xMPPLLConnection.getServiceName(), xMPPLLConnection);
    }

    void removeIngoingConnection(XMPPLLConnection xMPPLLConnection) {
        this.ingoing.remove(xMPPLLConnection.getServiceName());
    }

    void addOutgoingConnection(XMPPLLConnection xMPPLLConnection) {
        this.outgoing.put(xMPPLLConnection.getServiceName(), xMPPLLConnection);
    }

    void removeOutgoingConnection(XMPPLLConnection xMPPLLConnection) {
        this.outgoing.remove(xMPPLLConnection.getServiceName());
    }

    LLChat removeLLChat(String string) {
        return this.chats.remove(string);
    }

    void newLLChat(LLChat lLChat) {
        this.chats.put(lLChat.getServiceName(), lLChat);
        for (LLChatListener lLChatListener : this.chatListeners) {
            lLChatListener.newChat(lLChat);
        }
    }

    public LLChat getChat(String string) throws XMPPException {
        LLChat lLChat = this.chats.get(string);
        if (lLChat == null) {
            LLPresence lLPresence = this.getPresenceByServiceName(string);
            if (lLPresence == null) {
                throw new XMPPException("Can't initiate new chat to '" + string + "': mDNS presence unknown.");
            }
            lLChat = new LLChat(this, lLPresence);
            this.newLLChat(lLChat);
        }
        return lLChat;
    }

    public XMPPLLConnection getConnection(String string) throws XMPPException {
        XMPPLLConnection xMPPLLConnection = this.getConnectionTo(string);
        if (xMPPLLConnection != null) {
            return xMPPLLConnection;
        }
        LLPresence lLPresence = this.getPresenceByServiceName(string);
        if (lLPresence == null) {
            throw new XMPPException("Can't initiate connection, remote peer is not available.");
        }
        LLConnectionConfiguration lLConnectionConfiguration = new LLConnectionConfiguration(this.presence, lLPresence);
        xMPPLLConnection = new XMPPLLConnection(this, lLConnectionConfiguration);
        this.addAssociatedConnection(xMPPLLConnection);
        xMPPLLConnection.connect();
        this.addOutgoingConnection(xMPPLLConnection);
        return xMPPLLConnection;
    }

    void sendMessage(Message message) throws XMPPException {
        this.sendPacket(message);
    }

    public void sendPacket(Packet packet) throws XMPPException {
        this.getConnection(packet.getTo()).sendPacket(packet);
    }

    public IQ getIQResponse(IQ iQ) throws XMPPException {
        XMPPLLConnection xMPPLLConnection = this.getConnection(iQ.getTo());
        CollectorWrapper collectorWrapper = this.createPacketCollector(new AndFilter(new PacketIDFilter(iQ.getPacketID()), new OrFilter(new IQTypeFilter(IQ.Type.RESULT), new IQTypeFilter(IQ.Type.ERROR))));
        xMPPLLConnection.sendPacket(iQ);
        IQ iQ2 = (IQ)collectorWrapper.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collectorWrapper.cancel();
        if (iQ2 == null) {
            throw new XMPPException("No response from the remote host.");
        }
        return iQ2;
    }

    public void updatePresence(LLPresence lLPresence) throws XMPPException {
        this.presence.update(lLPresence);
        if (this.initiated) {
            this.updateText();
            this.reannounceService();
        }
    }

    public LLPresence getLocalPresence() {
        return this.presence;
    }

    static {
        SmackConfiguration.getVersion();
    }

    public class CollectorWrapper {
        private Set<PacketCollector> collectors = new CopyOnWriteArraySet<PacketCollector>();
        private PacketFilter packetFilter;
        private Object lock = new Object();

        private CollectorWrapper(PacketFilter packetFilter) {
            this.packetFilter = packetFilter;
            for (XMPPLLConnection xMPPLLConnection : LLService.this.getConnections()) {
                this.createPacketCollector(xMPPLLConnection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createPacketCollector(XMPPLLConnection xMPPLLConnection) {
            XMPPLLConnection xMPPLLConnection2 = xMPPLLConnection;
            synchronized (xMPPLLConnection2) {
                PacketCollector packetCollector = xMPPLLConnection.createPacketCollector(this.packetFilter);
                packetCollector.setLock(this.lock);
                this.collectors.add(packetCollector);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Packet nextResult(long l) {
            long l2 = l;
            long l3 = System.currentTimeMillis();
            try {
                while (true) {
                    for (PacketCollector packetCollector : this.collectors) {
                        if (packetCollector.isCanceled()) {
                            this.collectors.remove(packetCollector);
                            continue;
                        }
                        Packet packet = packetCollector.pollResult();
                        if (packet == null) continue;
                        return packet;
                    }
                    if (l2 <= 0L) break;
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait(l2);
                    }
                    long l4 = System.currentTimeMillis();
                    l2 -= l4 - l3;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }

        public void cancel() {
            for (PacketCollector packetCollector : this.collectors) {
                packetCollector.cancel();
            }
            LLService.this.collectorWrappers.remove(this);
        }
    }

    private static class ListenerWrapper {
        private PacketListener packetListener;
        private PacketFilter packetFilter;

        public ListenerWrapper(PacketListener packetListener, PacketFilter packetFilter) {
            this.packetListener = packetListener;
            this.packetFilter = packetFilter;
        }

        public void notifyListener(Packet packet) {
            if (this.packetFilter == null || this.packetFilter.accept(packet)) {
                this.packetListener.processPacket(packet);
            }
        }

        public PacketListener getPacketListener() {
            return this.packetListener;
        }

        public PacketFilter getPacketFilter() {
            return this.packetFilter;
        }
    }

    private class ConnectionInitiatorThread
    extends Thread {
        XMPPLLConnection connection;

        ConnectionInitiatorThread(XMPPLLConnection xMPPLLConnection) {
            this.connection = xMPPLLConnection;
        }

        @Override
        public void run() {
            try {
                this.connection.initListen();
            }
            catch (XMPPException xMPPException) {
                // empty catch block
            }
        }
    }

    private class MessageListener
    implements PacketListener {
        private MessageListener() {
        }

        @Override
        public void processPacket(Packet packet) {
            if (packet instanceof Message) {
                Message message = (Message)packet;
                String string = message.getFrom();
                LLPresence lLPresence = LLService.this.getPresenceByServiceName(string);
                try {
                    LLService.this.getChat(string).deliver(message);
                }
                catch (XMPPException xMPPException) {
                    LLService.this.service.unknownOriginMessage(message);
                }
            }
        }
    }

    private class ConnectionActivityListener
    implements ConnectionListener {
        private XMPPLLConnection connection;

        ConnectionActivityListener(XMPPLLConnection xMPPLLConnection) {
            this.connection = xMPPLLConnection;
        }

        @Override
        public void connectionClosed() {
            this.removeConnectionRecord();
        }

        @Override
        public void connectionClosedOnError(Exception exception) {
            this.removeConnectionRecord();
        }

        @Override
        public void reconnectingIn(int n) {
        }

        @Override
        public void reconnectionSuccessful() {
        }

        @Override
        public void reconnectionFailed(Exception exception) {
        }

        private void removeConnectionRecord() {
            if (this.connection.isInitiator()) {
                LLService.this.removeOutgoingConnection(this.connection);
            } else {
                LLService.this.removeIngoingConnection(this.connection);
            }
            LLService.this.removeAssociatedConnection(this.connection);
        }
    }
}

