/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.LinkedList;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;

public class PacketCollector {
    private int maxPackets = SmackConfiguration.getPacketCollectorSize();
    private PacketFilter packetFilter;
    private LinkedList<Packet> resultQueue;
    private Connection conection;
    private boolean cancelled = false;
    private Object lock = new Object();

    protected PacketCollector(Connection connection, PacketFilter packetFilter) {
        this.conection = connection;
        this.packetFilter = packetFilter;
        this.resultQueue = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setLock(Object object) {
        Object object2 = this.lock;
        this.lock = object;
        Object object3 = object2;
        synchronized (object3) {
            object2.notifyAll();
        }
    }

    protected PacketCollector(Connection connection, PacketFilter packetFilter, int n) {
        this(connection, packetFilter);
        this.maxPackets = n;
    }

    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.conection.removePacketCollector(this);
        }
    }

    public boolean isCanceled() {
        return this.cancelled;
    }

    public PacketFilter getPacketFilter() {
        return this.packetFilter;
    }

    public synchronized Packet pollResult() {
        if (this.resultQueue.isEmpty()) {
            return null;
        }
        return this.resultQueue.removeLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet nextResult() {
        while (this.resultQueue.isEmpty()) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return this.resultQueue.removeLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet nextResult(long l) {
        if (this.resultQueue.isEmpty()) {
            long l2 = System.currentTimeMillis();
            try {
                long l3;
                for (long i = l; this.resultQueue.isEmpty() && i > 0L; i -= l3 - l2) {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait(i);
                    }
                    l3 = System.currentTimeMillis();
                    l2 = l3;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.resultQueue.isEmpty()) {
                return null;
            }
            return this.resultQueue.removeLast();
        }
        return this.resultQueue.removeLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        if (this.packetFilter == null || this.packetFilter.accept(packet)) {
            if (this.resultQueue.size() == this.maxPackets) {
                this.resultQueue.removeLast();
            }
            this.resultQueue.addFirst(packet);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }
}

