/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.LLConnectionConfiguration;
import org.jivesoftware.smack.LLConnectionListener;
import org.jivesoftware.smack.LLPacketReader;
import org.jivesoftware.smack.LLPresence;
import org.jivesoftware.smack.LLService;
import org.jivesoftware.smack.PacketWriter;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;

public class XMPPLLConnection
extends XMPPConnection {
    private static final Set<LLConnectionListener> linkLocalListeners = new CopyOnWriteArraySet<LLConnectionListener>();
    private LLService service;
    private LLPresence localPresence;
    private LLPresence remotePresence;
    private boolean initiator;
    private long lastActivity = 0L;
    protected XMPPLLConnection connection = this;
    private Thread timeoutThread;

    XMPPLLConnection(LLService lLService, LLConnectionConfiguration lLConnectionConfiguration) {
        super(lLConnectionConfiguration);
        this.service = lLService;
        this.updateLastActivity();
        this.timeoutThread = new Thread(){

            @Override
            public void run() {
                try {
                    while (XMPPLLConnection.this.connection != null) {
                        Thread.sleep(14000L);
                        long l = new Date().getTime();
                        if (l - XMPPLLConnection.this.lastActivity <= 15000L) continue;
                        XMPPLLConnection.this.shutdown();
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    XMPPLLConnection.this.shutdown();
                }
            }
        };
        this.timeoutThread.setName("Smack Link-local Connection Timeout (" + this.connection.connectionCounterValue + ")");
        this.timeoutThread.setDaemon(true);
        if (lLConnectionConfiguration.isInitiator()) {
            this.localPresence = lLConnectionConfiguration.getLocalPresence();
            this.remotePresence = lLConnectionConfiguration.getRemotePresence();
            lLConnectionConfiguration.setServiceName(this.remotePresence.getServiceName());
            this.initiator = true;
        } else {
            this.localPresence = lLConnectionConfiguration.getLocalPresence();
            this.remotePresence = null;
            lLConnectionConfiguration.setServiceName(null);
            this.initiator = false;
            this.socket = lLConnectionConfiguration.getSocket();
        }
    }

    public boolean isInitiator() {
        return this.initiator;
    }

    @Override
    public String getUser() {
        return this.localPresence.getServiceName();
    }

    public void setServiceName(String string) {
        this.config.setServiceName(string);
    }

    void setRemotePresence(LLPresence lLPresence) {
        this.remotePresence = lLPresence;
    }

    void initListen() throws XMPPException {
        this.initConnection();
    }

    public static void addLLConnectionListener(LLConnectionListener lLConnectionListener) {
        linkLocalListeners.add(lLConnectionListener);
    }

    public static void removeLLConnectionListener(LLConnectionListener lLConnectionListener) {
        linkLocalListeners.remove(lLConnectionListener);
    }

    @Override
    public void connect() throws XMPPException {
        String string = this.remotePresence.getHost();
        int n = this.remotePresence.getPort();
        try {
            this.socket = new Socket(string, n);
        }
        catch (UnknownHostException unknownHostException) {
            String string2 = "Could not connect to " + string + ":" + n + ".";
            throw new XMPPException(string2, new XMPPError(XMPPError.Condition.remote_server_timeout, string2), unknownHostException);
        }
        catch (IOException iOException) {
            String string3 = "Error connecting to " + string + ":" + n + ".";
            throw new XMPPException(string3, new XMPPError(XMPPError.Condition.remote_server_error, string3), iOException);
        }
        this.initConnection();
        this.notifyLLListenersConnected();
    }

    public void streamInitiatingReceived() throws XMPPException {
        if (this.config.getServiceName() == null) {
            this.shutdown();
        } else {
            this.packetWriter = new PacketWriter(this);
            if (this.debugger != null && this.debugger.getWriterListener() != null) {
                this.addPacketListener(this.debugger.getWriterListener(), null);
            }
            this.packetWriter.startup();
            this.notifyLLListenersConnected();
        }
    }

    private void notifyLLListenersConnected() {
        for (LLConnectionListener lLConnectionListener : linkLocalListeners) {
            lLConnectionListener.connectionCreated(this);
        }
    }

    void updateLastActivity() {
        this.lastActivity = new Date().getTime();
    }

    @Override
    public void sendPacket(Packet packet) {
        this.updateLastActivity();
        packet.setFrom(this.getUser());
        super.sendPacket(packet);
    }

    private void initConnection() throws XMPPException {
        this.initReaderAndWriter();
        this.timeoutThread.start();
        try {
            if (this.isInitiator()) {
                this.packetWriter = new PacketWriter(this);
            }
            this.packetReader = new LLPacketReader(this.service, this);
            this.connected = true;
            if (this.isInitiator()) {
                this.packetWriter.startup();
            }
            this.packetReader.startup();
        }
        catch (XMPPException xMPPException) {
            if (this.packetWriter != null) {
                try {
                    this.packetWriter.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.packetWriter = null;
            }
            if (this.packetReader != null) {
                try {
                    this.packetReader.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.packetReader = null;
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.socket = null;
            }
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.reader = null;
            }
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.writer = null;
            }
            this.connected = false;
            throw xMPPException;
        }
    }

    private void initReaderAndWriter() throws XMPPException {
        try {
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
            this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
        }
        catch (IOException iOException) {
            throw new XMPPException("XMPPError establishing connection with server.", new XMPPError(XMPPError.Condition.remote_server_error, "XMPPError establishing connection with server."), iOException);
        }
    }

    protected void shutdown() {
        this.connection = null;
        if (this.packetReader != null) {
            this.packetReader.shutdown();
        }
        if (this.packetWriter != null) {
            this.packetWriter.shutdown();
        }
        try {
            Thread.sleep(150L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.writer = null;
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void disconnect() {
        if (this.packetReader == null || this.packetWriter == null) {
            return;
        }
        this.shutdown();
        this.packetWriter.cleanup();
        this.packetWriter = null;
        this.packetReader.cleanup();
        this.packetReader = null;
    }

    @Override
    public boolean isAddFrom() {
        return true;
    }
}

