/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class ProviderManager {
    private static ProviderManager instance;
    private Map<String, Object> extensionProviders = new ConcurrentHashMap<String, Object>();
    private Map<String, Object> iqProviders = new ConcurrentHashMap<String, Object>();

    public static synchronized ProviderManager getInstance() {
        if (instance == null) {
            instance = new ProviderManager();
        }
        return instance;
    }

    public static synchronized void setInstance(ProviderManager providerManager) {
        if (instance != null) {
            throw new IllegalStateException("ProviderManager singleton already set");
        }
        instance = providerManager;
    }

    protected void initialize() {
        try {
            ClassLoader[] classLoaderArray;
            for (ClassLoader classLoader : classLoaderArray = this.getClassLoaders()) {
                Enumeration<URL> enumeration = classLoader.getResources("META-INF/smack.providers");
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    InputStream inputStream = null;
                    inputStream = uRL.openStream();
                    this.loadFromXML(inputStream);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromXML(InputStream inputStream) throws Exception {
        try {
            XmlPullParser xmlPullParser = XmlPullParserFactory.newInstance().newPullParser();
            xmlPullParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            xmlPullParser.setInput(inputStream, "UTF-8");
            int n = xmlPullParser.getEventType();
            do {
                Class<?> clazz;
                String string;
                String string2;
                String string3;
                String string4;
                if (n != 2) continue;
                if (xmlPullParser.getName().equals("iqProvider")) {
                    xmlPullParser.next();
                    xmlPullParser.next();
                    string4 = xmlPullParser.nextText();
                    xmlPullParser.next();
                    xmlPullParser.next();
                    string3 = xmlPullParser.nextText();
                    xmlPullParser.next();
                    xmlPullParser.next();
                    string2 = xmlPullParser.nextText();
                    string = this.getProviderKey(string4, string3);
                    if (this.iqProviders.containsKey(string)) continue;
                    try {
                        clazz = Class.forName(string2);
                        if (IQProvider.class.isAssignableFrom(clazz)) {
                            this.iqProviders.put(string, clazz.newInstance());
                            continue;
                        }
                        if (!IQ.class.isAssignableFrom(clazz)) continue;
                        this.iqProviders.put(string, clazz);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        classNotFoundException.printStackTrace();
                    }
                    continue;
                }
                if (!xmlPullParser.getName().equals("extensionProvider")) continue;
                xmlPullParser.next();
                xmlPullParser.next();
                string4 = xmlPullParser.nextText();
                xmlPullParser.next();
                xmlPullParser.next();
                string3 = xmlPullParser.nextText();
                xmlPullParser.next();
                xmlPullParser.next();
                string2 = xmlPullParser.nextText();
                string = this.getProviderKey(string4, string3);
                if (this.extensionProviders.containsKey(string)) continue;
                try {
                    clazz = Class.forName(string2);
                    if (PacketExtensionProvider.class.isAssignableFrom(clazz)) {
                        this.extensionProviders.put(string, clazz.newInstance());
                        continue;
                    }
                    if (!PacketExtension.class.isAssignableFrom(clazz)) continue;
                    this.extensionProviders.put(string, clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            } while ((n = xmlPullParser.next()) != 1);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public Object getIQProvider(String string, String string2) {
        String string3 = this.getProviderKey(string, string2);
        return this.iqProviders.get(string3);
    }

    public Collection<Object> getIQProviders() {
        return Collections.unmodifiableCollection(this.iqProviders.values());
    }

    public void addIQProvider(String string, String string2, Object object) {
        if (!(object instanceof IQProvider || object instanceof Class && IQ.class.isAssignableFrom((Class)object))) {
            throw new IllegalArgumentException("Provider must be an IQProvider or a Class instance.");
        }
        String string3 = this.getProviderKey(string, string2);
        this.iqProviders.put(string3, object);
    }

    public void removeIQProvider(String string, String string2) {
        String string3 = this.getProviderKey(string, string2);
        this.iqProviders.remove(string3);
    }

    public Object getExtensionProvider(String string, String string2) {
        String string3 = this.getProviderKey(string, string2);
        return this.extensionProviders.get(string3);
    }

    public void addExtensionProvider(String string, String string2, Object object) {
        if (!(object instanceof PacketExtensionProvider) && !(object instanceof Class)) {
            throw new IllegalArgumentException("Provider must be a PacketExtensionProvider or a Class instance.");
        }
        String string3 = this.getProviderKey(string, string2);
        this.extensionProviders.put(string3, object);
    }

    public void removeExtensionProvider(String string, String string2) {
        String string3 = this.getProviderKey(string, string2);
        this.extensionProviders.remove(string3);
    }

    public Collection<Object> getExtensionProviders() {
        return Collections.unmodifiableCollection(this.extensionProviders.values());
    }

    private String getProviderKey(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(string).append("/><").append(string2).append("/>");
        return stringBuilder.toString();
    }

    private ClassLoader[] getClassLoaders() {
        ClassLoader[] classLoaderArray = new ClassLoader[]{ProviderManager.class.getClassLoader(), Thread.currentThread().getContextClassLoader()};
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>();
        for (ClassLoader classLoader : classLoaderArray) {
            if (classLoader == null) continue;
            arrayList.add(classLoader);
        }
        return arrayList.toArray(new ClassLoader[arrayList.size()]);
    }

    private ProviderManager() {
        this.initialize();
    }
}

