/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.entitycaps;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.Base64;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.ServiceDiscoveryManagerInterface;
import org.jivesoftware.smackx.entitycaps.CapsPacketListener;
import org.jivesoftware.smackx.entitycaps.CapsVerListener;
import org.jivesoftware.smackx.entitycaps.EntityCapsPersistentCache;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.provider.CapsExtensionProvider;

public class EntityCapsManager {
    public static final String HASH_METHOD = "sha-1";
    public static final String HASH_METHOD_CAPS = "SHA-1";
    private static String entityNode = "http://www.igniterealtime.org/projects/smack/";
    private static EntityCapsPersistentCache persistentCache;
    private static Map<String, DiscoverInfo> caps;
    private Map<String, String> userCaps = new ConcurrentHashMap<String, String>();
    private Set<CapsVerListener> capsVerListeners = new CopyOnWriteArraySet<CapsVerListener>();
    private String currentCapsVersion = null;

    public static void addDiscoverInfoByNode(String string, DiscoverInfo discoverInfo) {
        EntityCapsManager.cleanupDicsoverInfo(discoverInfo);
        caps.put(string, discoverInfo);
        if (persistentCache != null) {
            persistentCache.addDiscoverInfoByNodePersistent(string, discoverInfo);
        }
    }

    public EntityCapsManager(ServiceDiscoveryManagerInterface serviceDiscoveryManagerInterface) {
        serviceDiscoveryManagerInterface.addFeature("http://jabber.org/protocol/caps");
    }

    public void addUserCapsNode(String string, String string2) {
        if (string != null && string2 != null) {
            this.userCaps.put(string, string2);
        }
    }

    public void removeUserCapsNode(String string) {
        this.userCaps.remove(string);
    }

    public String getNodeVersionByUser(String string) {
        return this.userCaps.get(string);
    }

    public DiscoverInfo getDiscoverInfoByUser(String string) {
        String string2 = this.userCaps.get(string);
        if (string2 == null) {
            return null;
        }
        return EntityCapsManager.getDiscoverInfoByNode(string2);
    }

    public String getCapsVersion() {
        return this.currentCapsVersion;
    }

    public String getNode() {
        return entityNode;
    }

    public void setNode(String string) {
        entityNode = string;
    }

    public static DiscoverInfo getDiscoverInfoByNode(String string) {
        return caps.get(string);
    }

    private static void cleanupDicsoverInfo(DiscoverInfo discoverInfo) {
        discoverInfo.setFrom(null);
        discoverInfo.setTo(null);
        discoverInfo.setPacketID(null);
    }

    public void addPacketListener(Connection connection) {
        AndFilter andFilter = new AndFilter(new PacketTypeFilter(Presence.class), new PacketExtensionFilter("c", "http://jabber.org/protocol/caps"));
        connection.addPacketListener(new CapsPacketListener(this), andFilter);
    }

    public void addCapsVerListener(CapsVerListener capsVerListener) {
        this.capsVerListeners.add(capsVerListener);
        if (this.currentCapsVersion != null) {
            capsVerListener.capsVerUpdated(this.currentCapsVersion);
        }
    }

    public void removeCapsVerListener(CapsVerListener capsVerListener) {
        this.capsVerListeners.remove(capsVerListener);
    }

    private void notifyCapsVerListeners() {
        for (CapsVerListener capsVerListener : this.capsVerListeners) {
            capsVerListener.capsVerUpdated(this.currentCapsVersion);
        }
    }

    private static String capsToHash(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_METHOD_CAPS);
            byte[] byArray = messageDigest.digest(string.getBytes());
            return Base64.encodeBytes(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private static String formFieldValuesToCaps(Iterator<String> iterator) {
        String string = "";
        TreeSet<String> treeSet = new TreeSet<String>();
        while (iterator.hasNext()) {
            treeSet.add(iterator.next());
        }
        for (String string2 : treeSet) {
            string = string + string2 + "<";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateEntityCapsVersion(DiscoverInfo discoverInfo, String string, String string2, DataForm dataForm) {
        String string3 = "";
        string3 = string3 + "client/" + string + "//" + string2 + "<";
        TreeSet<String> treeSet = new TreeSet<String>();
        Object object = discoverInfo.getFeatures();
        while (object.hasNext()) {
            treeSet.add(object.next().getVar());
        }
        for (String object2 : treeSet) {
            string3 = string3 + object2 + "<";
        }
        if (dataForm != null) {
            object = dataForm;
            synchronized (object) {
                TreeSet<FormField> treeSet2 = new TreeSet<FormField>(new Comparator<FormField>(){

                    @Override
                    public int compare(FormField formField, FormField formField2) {
                        return formField.getVariable().compareTo(formField2.getVariable());
                    }
                });
                FormField formField = null;
                Iterator<FormField> iterator = dataForm.getFields();
                while (iterator.hasNext()) {
                    FormField formField2 = iterator.next();
                    if (!formField2.getVariable().equals("FORM_TYPE")) {
                        treeSet2.add(formField2);
                        continue;
                    }
                    formField = formField2;
                }
                if (formField != null) {
                    string3 = string3 + EntityCapsManager.formFieldValuesToCaps(formField.getValues());
                }
                for (FormField formField2 : treeSet2) {
                    string3 = string3 + formField2.getVariable() + "<";
                    string3 = string3 + EntityCapsManager.formFieldValuesToCaps(formField2.getValues());
                }
            }
        }
        this.setCurrentCapsVersion(discoverInfo, EntityCapsManager.capsToHash(string3));
    }

    public void setCurrentCapsVersion(DiscoverInfo discoverInfo, String string) {
        this.currentCapsVersion = string;
        EntityCapsManager.addDiscoverInfoByNode(this.getNode() + "#" + string, discoverInfo);
        this.notifyCapsVerListeners();
    }

    public static void setPersistentCache(EntityCapsPersistentCache entityCapsPersistentCache) {
        if (persistentCache != null) {
            throw new IllegalStateException("Entity Caps Persistent Cache was already set");
        }
        persistentCache = entityCapsPersistentCache;
        persistentCache.replay();
    }

    static {
        caps = new ConcurrentHashMap<String, DiscoverInfo>();
        ProviderManager.getInstance().addExtensionProvider("c", "http://jabber.org/protocol/caps", new CapsExtensionProvider());
    }
}

