/*
 * Decompiled with CFR 0.152.
 */
package org.jmdns.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import org.jmdns.impl.DNSEntry;

public class DNSCache {
    private static Logger logger = Logger.getLogger(DNSCache.class.getName());
    private int size;
    private final HashMap hashtable;

    public DNSCache(int n) {
        this.hashtable = new HashMap(n);
    }

    public synchronized void clear() {
        this.hashtable.clear();
        this.size = 0;
    }

    public synchronized void add(DNSEntry dNSEntry) {
        CacheNode cacheNode = new CacheNode(dNSEntry);
        CacheNode cacheNode2 = (CacheNode)this.hashtable.get(dNSEntry.getName());
        if (cacheNode2 == null) {
            this.hashtable.put(dNSEntry.getName(), cacheNode);
        } else {
            cacheNode.next = cacheNode2.next;
            cacheNode2.next = cacheNode;
        }
        ++this.size;
    }

    public synchronized boolean remove(DNSEntry dNSEntry) {
        CacheNode cacheNode = (CacheNode)this.hashtable.get(dNSEntry.getName());
        if (cacheNode != null) {
            if (cacheNode.value == dNSEntry) {
                if (cacheNode.next == null) {
                    this.hashtable.remove(dNSEntry.getName());
                } else {
                    this.hashtable.put(dNSEntry.getName(), cacheNode.next);
                }
                --this.size;
                return true;
            }
            CacheNode cacheNode2 = cacheNode;
            cacheNode = cacheNode.next;
            while (cacheNode != null) {
                if (cacheNode.value == dNSEntry) {
                    cacheNode2.next = cacheNode.next;
                    --this.size;
                    return true;
                }
                cacheNode2 = cacheNode;
                cacheNode = cacheNode.next;
            }
        }
        return false;
    }

    public synchronized DNSEntry get(DNSEntry dNSEntry) {
        CacheNode cacheNode = this.find(dNSEntry.getName());
        while (cacheNode != null) {
            if (cacheNode.value.equals(dNSEntry)) {
                return cacheNode.value;
            }
            cacheNode = cacheNode.next;
        }
        return null;
    }

    public synchronized DNSEntry get(String string, int n, int n2) {
        CacheNode cacheNode = this.find(string);
        while (cacheNode != null) {
            if (((CacheNode)cacheNode).value.type == n && ((CacheNode)cacheNode).value.clazz == n2) {
                return cacheNode.value;
            }
            cacheNode = cacheNode.next;
        }
        return null;
    }

    public synchronized Iterator iterator() {
        return new ArrayList(this.hashtable.values()).iterator();
    }

    public synchronized CacheNode find(String string) {
        return (CacheNode)this.hashtable.get(string);
    }

    public synchronized void print() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CacheNode cacheNode = (CacheNode)iterator.next();
            while (cacheNode != null) {
                System.out.println(cacheNode.value);
                cacheNode = cacheNode.next;
            }
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t---- cache ----");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CacheNode cacheNode = (CacheNode)iterator.next();
            while (cacheNode != null) {
                stringBuffer.append("\n\t\t" + cacheNode.value);
                cacheNode = cacheNode.next;
            }
        }
        return stringBuffer.toString();
    }

    public static class CacheNode {
        private static Logger logger = Logger.getLogger(CacheNode.class.getName());
        private final DNSEntry value;
        private CacheNode next;

        public CacheNode(DNSEntry dNSEntry) {
            this.value = dNSEntry;
        }

        public CacheNode next() {
            return this.next;
        }

        public DNSEntry getValue() {
            return this.value;
        }
    }
}

