/*
 * Decompiled with CFR 0.152.
 */
package org.jmdns.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jmdns.impl.DNSQuestion;
import org.jmdns.impl.DNSRecord;

public final class DNSIncoming {
    private static Logger logger = Logger.getLogger(DNSIncoming.class.getName());
    public static boolean USE_DOMAIN_NAME_FORMAT_FOR_SRV_TARGET = true;
    private DatagramPacket packet;
    private int off;
    private int len;
    private byte[] data;
    int id;
    private int flags;
    private int numQuestions;
    int numAnswers;
    private int numAuthorities;
    private int numAdditionals;
    private long receivedTime;
    private List questions;
    List answers;

    DNSIncoming(DatagramPacket datagramPacket) throws IOException {
        block23: {
            this.packet = datagramPacket;
            InetAddress inetAddress = datagramPacket.getAddress();
            this.data = datagramPacket.getData();
            this.len = datagramPacket.getLength();
            this.off = datagramPacket.getOffset();
            this.questions = Collections.EMPTY_LIST;
            this.answers = Collections.EMPTY_LIST;
            this.receivedTime = System.currentTimeMillis();
            try {
                int n;
                this.id = this.readUnsignedShort();
                this.flags = this.readUnsignedShort();
                this.numQuestions = this.readUnsignedShort();
                this.numAnswers = this.readUnsignedShort();
                this.numAuthorities = this.readUnsignedShort();
                this.numAdditionals = this.readUnsignedShort();
                if (this.numQuestions > 0) {
                    this.questions = Collections.synchronizedList(new ArrayList(this.numQuestions));
                    for (n = 0; n < this.numQuestions; ++n) {
                        DNSQuestion dNSQuestion = new DNSQuestion(this.readName(), this.readUnsignedShort(), this.readUnsignedShort());
                        this.questions.add(dNSQuestion);
                    }
                }
                if ((n = this.numAnswers + this.numAuthorities + this.numAdditionals) <= 0) break block23;
                this.answers = Collections.synchronizedList(new ArrayList(n));
                for (int i = 0; i < n; ++i) {
                    String string = this.readName();
                    int n2 = this.readUnsignedShort();
                    int n3 = this.readUnsignedShort();
                    int n4 = this.readInt();
                    int n5 = this.readUnsignedShort();
                    int n6 = this.off + n5;
                    DNSRecord dNSRecord = null;
                    switch (n2) {
                        case 1: 
                        case 28: {
                            dNSRecord = new DNSRecord.Address(string, n2, n3, n4, this.readBytes(this.off, n5));
                            break;
                        }
                        case 5: 
                        case 12: {
                            String string2 = "";
                            try {
                                string2 = this.readName();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            dNSRecord = new DNSRecord.Pointer(string, n2, n3, n4, string2);
                            break;
                        }
                        case 16: {
                            dNSRecord = new DNSRecord.Text(string, n2, n3, n4, this.readBytes(this.off, n5));
                            break;
                        }
                        case 33: {
                            int n7 = this.readUnsignedShort();
                            int n8 = this.readUnsignedShort();
                            int n9 = this.readUnsignedShort();
                            String string3 = "";
                            try {
                                string3 = USE_DOMAIN_NAME_FORMAT_FOR_SRV_TARGET ? this.readName() : this.readNonNameString();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            dNSRecord = new DNSRecord.Service(string, n2, n3, n4, n7, n8, n9, string3);
                            break;
                        }
                        case 13: {
                            break;
                        }
                        default: {
                            logger.finer("DNSIncoming() unknown type:" + n2);
                        }
                    }
                    if (dNSRecord != null) {
                        dNSRecord.setRecordSource(inetAddress);
                        this.answers.add(dNSRecord);
                    } else if (this.answers.size() < this.numAnswers) {
                        --this.numAnswers;
                    } else if (this.answers.size() < this.numAnswers + this.numAuthorities) {
                        --this.numAuthorities;
                    } else if (this.answers.size() < this.numAnswers + this.numAuthorities + this.numAdditionals) {
                        --this.numAdditionals;
                    }
                    this.off = n6;
                }
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "DNSIncoming() dump " + this.print(true) + "\n exception ", iOException);
                throw iOException;
            }
        }
    }

    boolean isQuery() {
        return (this.flags & 0x8000) == 0;
    }

    public boolean isTruncated() {
        return (this.flags & 0x200) != 0;
    }

    boolean isResponse() {
        return (this.flags & 0x8000) == 32768;
    }

    private int get(int n) throws IOException {
        if (n < 0 || n >= this.len) {
            throw new IOException("parser error: offset=" + n);
        }
        return this.data[n] & 0xFF;
    }

    private int readUnsignedShort() throws IOException {
        return (this.get(this.off++) << 8) + this.get(this.off++);
    }

    private int readInt() throws IOException {
        return (this.readUnsignedShort() << 16) + this.readUnsignedShort();
    }

    private byte[] readBytes(int n, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.data, n, byArray, 0, n2);
        return byArray;
    }

    private void readUTF(StringBuffer stringBuffer, int n, int n2) throws IOException {
        int n3 = n + n2;
        while (n < n3) {
            int n4 = this.get(n++);
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 12: 
                case 13: {
                    n4 = (n4 & 0x1F) << 6 | this.get(n++) & 0x3F;
                    break;
                }
                case 14: {
                    n4 = (n4 & 0xF) << 12 | (this.get(n++) & 0x3F) << 6 | this.get(n++) & 0x3F;
                    break;
                }
                default: {
                    n4 = (n4 & 0x3F) << 4 | this.get(n++) & 0xF;
                }
            }
            stringBuffer.append((char)n4);
        }
    }

    private String readNonNameString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.off;
        int n2 = this.get(n++);
        this.readUTF(stringBuffer, n, n2);
        return stringBuffer.toString();
    }

    private String readName() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.off;
        int n3 = -1;
        int n4 = n2;
        block4: while ((n = this.get(n2++)) != 0) {
            switch (n & 0xC0) {
                case 0: {
                    this.readUTF(stringBuffer, n2, n);
                    n2 += n;
                    stringBuffer.append('.');
                    continue block4;
                }
                case 192: {
                    if (n3 < 0) {
                        n3 = n2 + 1;
                    }
                    if ((n2 = (n & 0x3F) << 8 | this.get(n2++)) >= n4) {
                        throw new IOException("bad domain name: possible circular name detected. name start: " + n4 + " bad offset: 0x" + Integer.toHexString(n2));
                    }
                    n4 = n2;
                    continue block4;
                }
            }
            throw new IOException("unsupported dns label type: '" + Integer.toHexString(n & 0xC0) + "' at " + (n2 - 1));
        }
        this.off = n3 >= 0 ? n3 : n2;
        return stringBuffer.toString();
    }

    String print(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toString() + "\n");
        Iterator iterator = this.questions.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("    ques:" + iterator.next() + "\n");
        }
        int n = 0;
        Iterator iterator2 = this.answers.iterator();
        while (iterator2.hasNext()) {
            if (n < this.numAnswers) {
                stringBuffer.append("    answ:");
            } else if (n < this.numAnswers + this.numAuthorities) {
                stringBuffer.append("    auth:");
            } else {
                stringBuffer.append("    addi:");
            }
            stringBuffer.append(iterator2.next() + "\n");
            ++n;
        }
        if (bl) {
            int n2 = this.packet.getLength();
            for (int i = 0; i < n2; i += 32) {
                int n3;
                int n4 = Math.min(32, n2 - i);
                if (i < 10) {
                    stringBuffer.append(' ');
                }
                if (i < 100) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(i);
                stringBuffer.append(':');
                for (n3 = 0; n3 < n4; ++n3) {
                    if (n3 % 8 == 0) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(Integer.toHexString((this.data[i + n3] & 0xF0) >> 4));
                    stringBuffer.append(Integer.toHexString((this.data[i + n3] & 0xF) >> 0));
                }
                stringBuffer.append("\n");
                stringBuffer.append("    ");
                for (n3 = 0; n3 < n4; ++n3) {
                    if (n3 % 8 == 0) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(' ');
                    int n5 = this.data[i + n3] & 0xFF;
                    stringBuffer.append(n5 > 32 && n5 < 127 ? (char)n5 : (char)'.');
                }
                stringBuffer.append("\n");
                if (i + 32 < 256) continue;
                stringBuffer.append("....\n");
                break;
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.isQuery() ? "dns[query," : "dns[response,");
        if (this.packet.getAddress() != null) {
            stringBuffer.append(this.packet.getAddress().getHostAddress());
        }
        stringBuffer.append(':');
        stringBuffer.append(this.packet.getPort());
        stringBuffer.append(",len=");
        stringBuffer.append(this.packet.getLength());
        stringBuffer.append(",id=0x");
        stringBuffer.append(Integer.toHexString(this.id));
        if (this.flags != 0) {
            stringBuffer.append(",flags=0x");
            stringBuffer.append(Integer.toHexString(this.flags));
            if ((this.flags & 0x8000) != 0) {
                stringBuffer.append(":r");
            }
            if ((this.flags & 0x400) != 0) {
                stringBuffer.append(":aa");
            }
            if ((this.flags & 0x200) != 0) {
                stringBuffer.append(":tc");
            }
        }
        if (this.numQuestions > 0) {
            stringBuffer.append(",questions=");
            stringBuffer.append(this.numQuestions);
        }
        if (this.numAnswers > 0) {
            stringBuffer.append(",answers=");
            stringBuffer.append(this.numAnswers);
        }
        if (this.numAuthorities > 0) {
            stringBuffer.append(",authorities=");
            stringBuffer.append(this.numAuthorities);
        }
        if (this.numAdditionals > 0) {
            stringBuffer.append(",additionals=");
            stringBuffer.append(this.numAdditionals);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    void append(DNSIncoming dNSIncoming) {
        if (this.isQuery() && this.isTruncated() && dNSIncoming.isQuery()) {
            if (dNSIncoming.numQuestions > 0) {
                if (Collections.EMPTY_LIST.equals(this.questions)) {
                    this.questions = Collections.synchronizedList(new ArrayList(dNSIncoming.numQuestions));
                }
                this.questions.addAll(dNSIncoming.questions);
                this.numQuestions += dNSIncoming.numQuestions;
            }
            if (Collections.EMPTY_LIST.equals(this.answers)) {
                this.answers = Collections.synchronizedList(new ArrayList());
            }
            if (dNSIncoming.numAnswers > 0) {
                this.answers.addAll(this.numAnswers, dNSIncoming.answers.subList(0, dNSIncoming.numAnswers));
                this.numAnswers += dNSIncoming.numAnswers;
            }
            if (dNSIncoming.numAuthorities > 0) {
                this.answers.addAll(this.numAnswers + this.numAuthorities, dNSIncoming.answers.subList(dNSIncoming.numAnswers, dNSIncoming.numAnswers + dNSIncoming.numAuthorities));
                this.numAuthorities += dNSIncoming.numAuthorities;
            }
            if (dNSIncoming.numAdditionals > 0) {
                this.answers.addAll(dNSIncoming.answers.subList(dNSIncoming.numAnswers + dNSIncoming.numAuthorities, dNSIncoming.numAnswers + dNSIncoming.numAuthorities + dNSIncoming.numAdditionals));
                this.numAdditionals += dNSIncoming.numAdditionals;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public int elapseSinceArrival() {
        return (int)(System.currentTimeMillis() - this.receivedTime);
    }

    public List getQuestions() {
        return this.questions;
    }

    public List getAnswers() {
        return this.answers;
    }
}

