/*
 * Decompiled with CFR 0.152.
 */
package org.jmdns.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jmdns.JmDNS;
import org.jmdns.ServiceEvent;
import org.jmdns.ServiceInfo;
import org.jmdns.ServiceListener;
import org.jmdns.ServiceTypeListener;
import org.jmdns.impl.DNSCache;
import org.jmdns.impl.DNSIncoming;
import org.jmdns.impl.DNSListener;
import org.jmdns.impl.DNSOutgoing;
import org.jmdns.impl.DNSQuestion;
import org.jmdns.impl.DNSRecord;
import org.jmdns.impl.DNSState;
import org.jmdns.impl.HostInfo;
import org.jmdns.impl.ServiceEventImpl;
import org.jmdns.impl.ServiceInfoImpl;
import org.jmdns.impl.SocketListener;
import org.jmdns.impl.tasks.Announcer;
import org.jmdns.impl.tasks.Canceler;
import org.jmdns.impl.tasks.Prober;
import org.jmdns.impl.tasks.RecordReaper;
import org.jmdns.impl.tasks.Renewer;
import org.jmdns.impl.tasks.Responder;
import org.jmdns.impl.tasks.ServiceInfoResolver;
import org.jmdns.impl.tasks.ServiceResolver;
import org.jmdns.impl.tasks.TextAnnouncer;
import org.jmdns.impl.tasks.TypeResolver;

public class JmDNSImpl
extends JmDNS {
    private static Logger logger = Logger.getLogger(JmDNSImpl.class.getName());
    private InetAddress group;
    private MulticastSocket socket;
    private boolean closed = false;
    private List listeners;
    private Map serviceListeners;
    private List typeListeners;
    private DNSCache cache;
    Map services;
    Map serviceTypes;
    private Thread shutdown;
    private HostInfo localHost;
    private Thread incomingListener = null;
    private int throttle;
    private long lastThrottleIncrement;
    Timer timer;
    private static final Random random = new Random();
    private Object ioLock = new Object();
    private DNSIncoming plannedAnswer;
    private DNSState state = DNSState.PROBING_1;
    private TimerTask task;
    private final HashMap serviceCollectors = new HashMap();

    public JmDNSImpl() throws IOException {
        logger.finer("JmDNS instance created");
        InetAddress inetAddress = InetAddress.getLocalHost();
        this.init(inetAddress.isLoopbackAddress() ? null : inetAddress, inetAddress.getHostName());
    }

    public JmDNSImpl(InetAddress inetAddress) throws IOException {
        String string = inetAddress.getHostName();
        this.init(inetAddress, string);
    }

    private void init(InetAddress inetAddress, String string) throws IOException {
        int n = string.indexOf(".");
        if (n > 0) {
            string = string.substring(0, n);
        }
        string = string + ".local.";
        this.localHost = new HostInfo(inetAddress, string);
        this.cache = new DNSCache(100);
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.serviceListeners = new HashMap();
        this.typeListeners = new ArrayList();
        this.services = new Hashtable(20);
        this.serviceTypes = new Hashtable(20);
        this.timer = new Timer();
        new RecordReaper(this).start(this.timer);
        this.shutdown = new Thread((Runnable)new Shutdown(), "JmDNS.Shutdown");
        Runtime.getRuntime().addShutdownHook(this.shutdown);
        this.incomingListener = new Thread((Runnable)new SocketListener(this), "JmDNS.SocketListener");
        this.openMulticastSocket(this.getLocalHost());
        this.start(this.getServices().values());
    }

    private void start(Collection collection) {
        this.setState(DNSState.PROBING_1);
        this.incomingListener.start();
        new Prober(this).start(this.timer);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                this.registerService(new ServiceInfoImpl((ServiceInfoImpl)iterator.next()));
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "start() Registration exception ", exception);
            }
        }
    }

    private void openMulticastSocket(HostInfo hostInfo) throws IOException {
        if (this.group == null) {
            this.group = InetAddress.getByName("224.0.0.251");
        }
        if (this.socket != null) {
            this.closeMulticastSocket();
        }
        this.socket = new MulticastSocket(5353);
        if (hostInfo != null && this.localHost.getInterface() != null) {
            this.socket.setNetworkInterface(hostInfo.getInterface());
        }
        this.socket.setTimeToLive(255);
        this.socket.joinGroup(this.group);
    }

    private void closeMulticastSocket() {
        logger.finer("closeMulticastSocket()");
        if (this.socket != null) {
            try {
                this.socket.leaveGroup(this.group);
                this.socket.close();
                if (this.incomingListener != null) {
                    this.incomingListener.join();
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "closeMulticastSocket() Close socket exception ", exception);
            }
            this.socket = null;
        }
    }

    public synchronized void advanceState() {
        this.setState(this.getState().advance());
        this.notifyAll();
    }

    synchronized void revertState() {
        this.setState(this.getState().revert());
        this.notifyAll();
    }

    synchronized void cancel() {
        this.setState(DNSState.CANCELED);
        this.notifyAll();
    }

    public DNSState getState() {
        return this.state;
    }

    public DNSCache getCache() {
        return this.cache;
    }

    @Override
    public String getHostName() {
        return this.localHost.getName();
    }

    public HostInfo getLocalHost() {
        return this.localHost;
    }

    @Override
    public InetAddress getInterface() throws IOException {
        return this.socket.getInterface();
    }

    @Override
    public ServiceInfo getServiceInfo(String string, String string2) {
        return this.getServiceInfo(string, string2, 3000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInfo getServiceInfo(String string, String string2, int n) {
        ServiceInfoImpl serviceInfoImpl = new ServiceInfoImpl(string, string2);
        new ServiceInfoResolver(this, serviceInfoImpl).start(this.timer);
        try {
            long l = System.currentTimeMillis() + (long)n;
            ServiceInfoImpl serviceInfoImpl2 = serviceInfoImpl;
            synchronized (serviceInfoImpl2) {
                long l2;
                while (!serviceInfoImpl.hasData() && (l2 = l - System.currentTimeMillis()) > 0L) {
                    serviceInfoImpl.wait(l2);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return serviceInfoImpl.hasData() ? serviceInfoImpl : null;
    }

    @Override
    public void requestServiceInfo(String string, String string2) {
        this.requestServiceInfo(string, string2, false, 3000);
    }

    @Override
    public void requestServiceInfo(String string, String string2, boolean bl) {
        this.requestServiceInfo(string, string2, bl, 3000);
    }

    @Override
    public void requestServiceInfo(String string, String string2, int n) {
        this.requestServiceInfo(string, string2, false, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestServiceInfo(String string, String string2, boolean bl, int n) {
        this.registerServiceType(string);
        ServiceInfoImpl serviceInfoImpl = new ServiceInfoImpl(string, string2);
        new ServiceInfoResolver(this, serviceInfoImpl, bl).start(this.timer);
        try {
            long l = System.currentTimeMillis() + (long)n;
            ServiceInfoImpl serviceInfoImpl2 = serviceInfoImpl;
            synchronized (serviceInfoImpl2) {
                long l2;
                while (!serviceInfoImpl.hasData() && (l2 = l - System.currentTimeMillis()) > 0L) {
                    serviceInfoImpl.wait(l2);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleServiceResolved(ServiceInfoImpl serviceInfoImpl) {
        List list = null;
        ArrayList arrayList = null;
        Object object = this.serviceListeners;
        synchronized (object) {
            list = (List)this.serviceListeners.get(serviceInfoImpl.type.toLowerCase());
            if (list != null) {
                arrayList = new ArrayList(list);
            }
        }
        if (arrayList != null) {
            object = new ServiceEventImpl(this, serviceInfoImpl.type, serviceInfoImpl.getName(), serviceInfoImpl);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((ServiceListener)iterator.next()).serviceResolved((ServiceEvent)object);
            }
        }
    }

    void handleNewTXT(ServiceInfoImpl serviceInfoImpl) {
        this.handleServiceResolved(serviceInfoImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceTypeListener(ServiceTypeListener serviceTypeListener) throws IOException {
        Object object = this;
        synchronized (object) {
            this.typeListeners.remove(serviceTypeListener);
            this.typeListeners.add(serviceTypeListener);
        }
        object = this.serviceTypes.values().iterator();
        while (object.hasNext()) {
            serviceTypeListener.serviceTypeAdded(new ServiceEventImpl(this, (String)object.next(), null, null));
        }
        new TypeResolver(this).start(this.timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceTypeListener(ServiceTypeListener serviceTypeListener) {
        JmDNSImpl jmDNSImpl = this;
        synchronized (jmDNSImpl) {
            this.typeListeners.remove(serviceTypeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceListener(String string, ServiceListener serviceListener) {
        String string2 = string.toLowerCase();
        this.removeServiceListener(string2, serviceListener);
        List<ServiceListener> list = null;
        Object object = this.serviceListeners;
        synchronized (object) {
            list = (List<ServiceListener>)this.serviceListeners.get(string2);
            if (list == null) {
                list = Collections.synchronizedList(new LinkedList());
                this.serviceListeners.put(string2, list);
            }
            list.add(serviceListener);
        }
        object = new ArrayList();
        Object object2 = this.cache;
        synchronized (object2) {
            Iterator iterator = this.cache.iterator();
            while (iterator.hasNext()) {
                for (DNSCache.CacheNode cacheNode = (DNSCache.CacheNode)iterator.next(); cacheNode != null; cacheNode = cacheNode.next()) {
                    DNSRecord dNSRecord = (DNSRecord)cacheNode.getValue();
                    if (dNSRecord.type != 33 || !dNSRecord.name.endsWith(string)) continue;
                    object.add(new ServiceEventImpl(this, string, JmDNSImpl.toUnqualifiedName(string, dNSRecord.name), null));
                }
            }
        }
        object2 = object.iterator();
        while (object2.hasNext()) {
            serviceListener.serviceAdded((ServiceEventImpl)object2.next());
        }
        new ServiceResolver(this, string).start(this.timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceListener(String string, ServiceListener serviceListener) {
        string = string.toLowerCase();
        List list = null;
        Map map = this.serviceListeners;
        synchronized (map) {
            list = (List)this.serviceListeners.get(string);
            if (list != null) {
                list.remove(serviceListener);
                if (list.size() == 0) {
                    this.serviceListeners.remove(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerService(ServiceInfo serviceInfo) throws IOException {
        ServiceInfoImpl serviceInfoImpl = (ServiceInfoImpl)serviceInfo;
        this.registerServiceType(serviceInfoImpl.type);
        serviceInfoImpl.server = this.localHost.getName();
        serviceInfoImpl.addr = this.localHost.getAddress();
        Object object = this;
        synchronized (object) {
            this.makeServiceNameUnique(serviceInfoImpl);
            this.services.put(serviceInfoImpl.getQualifiedName().toLowerCase(), serviceInfoImpl);
        }
        new Prober(this).start(this.timer);
        try {
            object = serviceInfoImpl;
            synchronized (object) {
                while (serviceInfoImpl.getState().compareTo(DNSState.ANNOUNCED) < 0) {
                    serviceInfoImpl.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.fine("registerService() JmDNS registered service as " + serviceInfoImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reannounceService(ServiceInfo serviceInfo) throws IOException {
        ServiceInfoImpl serviceInfoImpl = (ServiceInfoImpl)serviceInfo;
        if (this.services.containsKey(serviceInfoImpl.getQualifiedName().toLowerCase())) {
            ServiceInfoImpl serviceInfoImpl2 = (ServiceInfoImpl)this.services.get(serviceInfoImpl.getQualifiedName().toLowerCase());
            serviceInfoImpl.setStateAnnounce();
            this.startTextAnnouncer();
            try {
                ServiceInfoImpl serviceInfoImpl3 = serviceInfoImpl;
                synchronized (serviceInfoImpl3) {
                    while (serviceInfoImpl.getState().compareTo(DNSState.ANNOUNCED) < 0) {
                        serviceInfoImpl.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.fine("reannounceService() JmDNS reannounced service " + serviceInfoImpl);
        } else {
            logger.fine("reannounceService() service to be announced not found: " + serviceInfoImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterService(ServiceInfo serviceInfo) {
        ServiceInfoImpl serviceInfoImpl = (ServiceInfoImpl)serviceInfo;
        Object object = this;
        synchronized (object) {
            this.services.remove(serviceInfoImpl.getQualifiedName().toLowerCase());
        }
        serviceInfoImpl.cancel();
        object = new Object();
        new Canceler(this, serviceInfoImpl, object).start(this.timer);
        try {
            Object object2 = object;
            synchronized (object2) {
                object.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAllServices() {
        LinkedList linkedList;
        logger.finer("unregisterAllServices()");
        if (this.services.size() == 0) {
            return;
        }
        Object object = this;
        synchronized (object) {
            linkedList = new LinkedList(this.services.values());
            this.services.clear();
        }
        object = linkedList.iterator();
        while (object.hasNext()) {
            ((ServiceInfoImpl)object.next()).cancel();
        }
        object = new Object();
        new Canceler(this, linkedList, object).start(this.timer);
        try {
            Object object2 = object;
            synchronized (object2) {
                if (!this.closed) {
                    object.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerServiceType(String string) {
        String string2 = string.toLowerCase();
        if (this.serviceTypes.get(string2) == null && string.indexOf("._mdns._udp.") < 0 && !string.endsWith(".in-addr.arpa.")) {
            LinkedList linkedList;
            Object object = this;
            synchronized (object) {
                this.serviceTypes.put(string2, string);
                linkedList = new LinkedList(this.typeListeners);
            }
            object = linkedList.iterator();
            while (object.hasNext()) {
                ((ServiceTypeListener)object.next()).serviceTypeAdded(new ServiceEventImpl(this, string, null, null));
            }
        }
    }

    private boolean makeHostNameUnique(DNSRecord.Address address) {
        boolean bl;
        String string = address.getName();
        System.currentTimeMillis();
        do {
            bl = false;
            for (DNSCache.CacheNode cacheNode = this.cache.find(address.getName().toLowerCase()); cacheNode != null; cacheNode = cacheNode.next()) {
            }
        } while (bl);
        return !string.equals(address.getName());
    }

    private boolean makeServiceNameUnique(ServiceInfoImpl serviceInfoImpl) {
        boolean bl;
        String string = serviceInfoImpl.getQualifiedName();
        long l = System.currentTimeMillis();
        do {
            DNSCache.CacheNode cacheNode;
            bl = false;
            for (cacheNode = this.cache.find(serviceInfoImpl.getQualifiedName().toLowerCase()); cacheNode != null; cacheNode = cacheNode.next()) {
                DNSRecord dNSRecord = (DNSRecord)cacheNode.getValue();
                if (dNSRecord.type != 33 || dNSRecord.isExpired(l)) continue;
                DNSRecord.Service service = (DNSRecord.Service)dNSRecord;
                if (service.port == serviceInfoImpl.port && service.server.equals(this.localHost.getName())) continue;
                logger.finer("makeServiceNameUnique() JmDNS.makeServiceNameUnique srv collision:" + dNSRecord + " s.server=" + service.server + " " + this.localHost.getName() + " equals:" + service.server.equals(this.localHost.getName()));
                serviceInfoImpl.setName(this.incrementName(serviceInfoImpl.getName()));
                bl = true;
                break;
            }
            if ((cacheNode = this.services.get(serviceInfoImpl.getQualifiedName().toLowerCase())) == null || cacheNode == serviceInfoImpl) continue;
            serviceInfoImpl.setName(this.incrementName(serviceInfoImpl.getName()));
            bl = true;
        } while (bl);
        return !string.equals(serviceInfoImpl.getQualifiedName());
    }

    String incrementName(String string) {
        try {
            int n = string.lastIndexOf(40);
            int n2 = string.lastIndexOf(41);
            string = n >= 0 && n < n2 ? string.substring(0, n) + "(" + (Integer.parseInt(string.substring(n + 1, n2)) + 1) + ")" : string + " (2)";
        }
        catch (NumberFormatException numberFormatException) {
            string = string + " (2)";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DNSListener dNSListener, DNSQuestion dNSQuestion) {
        long l = System.currentTimeMillis();
        Object object = this;
        synchronized (object) {
            this.listeners.add(dNSListener);
        }
        if (dNSQuestion != null) {
            for (object = this.cache.find(dNSQuestion.name); object != null; object = ((DNSCache.CacheNode)object).next()) {
                DNSRecord dNSRecord = (DNSRecord)((DNSCache.CacheNode)object).getValue();
                if (!dNSQuestion.answeredBy(dNSRecord) || dNSRecord.isExpired(l)) continue;
                dNSListener.updateRecord(this, l, dNSRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DNSListener dNSListener) {
        JmDNSImpl jmDNSImpl = this;
        synchronized (jmDNSImpl) {
            this.listeners.remove(dNSListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(long l, DNSRecord dNSRecord) {
        block13: {
            Object object2;
            ArrayList arrayList = null;
            ArrayList arrayList2 = this;
            synchronized (arrayList2) {
                arrayList = new ArrayList(this.listeners);
            }
            for (Object object2 : arrayList) {
                object2.updateRecord(this, l, dNSRecord);
            }
            if (dNSRecord.type != 12 && dNSRecord.type != 33) break block13;
            arrayList2 = null;
            object2 = this.serviceListeners;
            synchronized (object2) {
                arrayList2 = (List)this.serviceListeners.get(dNSRecord.name.toLowerCase());
                if (arrayList2 != null) {
                    arrayList2 = new ArrayList(arrayList2);
                }
            }
            if (arrayList2 != null) {
                boolean bl = dNSRecord.isExpired(l);
                String string = dNSRecord.getName();
                String string2 = ((DNSRecord.Pointer)dNSRecord).getAlias();
                if (!bl) {
                    ServiceEventImpl serviceEventImpl = new ServiceEventImpl(this, string, JmDNSImpl.toUnqualifiedName(string, string2), null);
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        ((ServiceListener)iterator.next()).serviceAdded(serviceEventImpl);
                    }
                } else {
                    ServiceEventImpl serviceEventImpl = new ServiceEventImpl(this, string, JmDNSImpl.toUnqualifiedName(string, string2), null);
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        ((ServiceListener)iterator.next()).serviceRemoved(serviceEventImpl);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleResponse(DNSIncoming dNSIncoming) throws IOException {
        long l = System.currentTimeMillis();
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = dNSIncoming.answers.iterator();
        block6: while (iterator.hasNext()) {
            boolean bl3 = false;
            DNSRecord dNSRecord = (DNSRecord)iterator.next();
            boolean bl4 = dNSRecord.isExpired(l);
            DNSCache dNSCache = this.cache;
            synchronized (dNSCache) {
                DNSRecord dNSRecord2 = dNSRecord instanceof DNSRecord.Text ? (DNSRecord)this.cache.get(dNSRecord.getName(), 16, 1) : (DNSRecord)this.cache.get(dNSRecord);
                if (dNSRecord2 != null) {
                    if (bl4) {
                        bl3 = true;
                        this.cache.remove(dNSRecord2);
                    } else if (dNSRecord instanceof DNSRecord.Text && !dNSRecord.sameValue(dNSRecord2)) {
                        bl3 = true;
                        this.cache.remove(dNSRecord2);
                        this.cache.add(dNSRecord);
                    } else {
                        dNSRecord2.resetTTL(dNSRecord);
                        dNSRecord = dNSRecord2;
                    }
                } else if (!bl4) {
                    bl3 = true;
                    this.cache.add(dNSRecord);
                }
            }
            switch (dNSRecord.type) {
                case 12: {
                    if (dNSRecord.getName().indexOf("._mdns._udp.") >= 0) {
                        if (bl4 || !dNSRecord.name.startsWith("_services._mdns._udp.")) continue block6;
                        bl3 = true;
                        this.registerServiceType(((DNSRecord.Pointer)dNSRecord).alias);
                        continue block6;
                    }
                    this.registerServiceType(dNSRecord.name);
                }
            }
            if (dNSRecord.getType() == 1 || dNSRecord.getType() == 28) {
                bl |= dNSRecord.handleResponse(this);
            } else {
                bl2 |= dNSRecord.handleResponse(this);
            }
            if (!bl3) continue;
            this.updateRecord(l, dNSRecord);
        }
        if (bl || bl2) {
            new Prober(this).start(this.timer);
        }
    }

    void handleQuery(DNSIncoming dNSIncoming, InetAddress inetAddress, int n) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        long l = System.currentTimeMillis() + 120L;
        for (DNSRecord dNSRecord : dNSIncoming.answers) {
            if (dNSRecord.getType() == 1 || dNSRecord.getType() == 28) {
                bl |= dNSRecord.handleQuery(this, l);
                continue;
            }
            bl2 |= dNSRecord.handleQuery(this, l);
        }
        if (this.plannedAnswer != null) {
            this.plannedAnswer.append(dNSIncoming);
        } else {
            if (dNSIncoming.isTruncated()) {
                this.plannedAnswer = dNSIncoming;
            }
            new Responder(this, dNSIncoming, inetAddress, n).start();
        }
        if (bl || bl2) {
            new Prober(this).start(this.timer);
        }
    }

    public DNSOutgoing addAnswer(DNSIncoming dNSIncoming, InetAddress inetAddress, int n, DNSOutgoing dNSOutgoing, DNSRecord dNSRecord) throws IOException {
        if (dNSOutgoing == null) {
            dNSOutgoing = new DNSOutgoing(33792);
        }
        try {
            dNSOutgoing.addAnswer(dNSIncoming, dNSRecord);
        }
        catch (IOException iOException) {
            dNSOutgoing.flags |= 0x200;
            dNSOutgoing.id = dNSIncoming.id;
            dNSOutgoing.finish();
            this.send(dNSOutgoing);
            dNSOutgoing = new DNSOutgoing(33792);
            dNSOutgoing.addAnswer(dNSIncoming, dNSRecord);
        }
        return dNSOutgoing;
    }

    public void send(DNSOutgoing dNSOutgoing) throws IOException {
        dNSOutgoing.finish();
        if (!dNSOutgoing.isEmpty()) {
            Object object;
            DatagramPacket datagramPacket = new DatagramPacket(dNSOutgoing.data, dNSOutgoing.off, this.group, 5353);
            try {
                object = new DNSIncoming(datagramPacket);
                logger.finest("send() JmDNS out:" + ((DNSIncoming)object).print(true));
            }
            catch (IOException iOException) {
                logger.throwing(this.getClass().toString(), "send(DNSOutgoing) - JmDNS can not parse what it sends!!!", iOException);
            }
            object = this.socket;
            if (object != null && !((DatagramSocket)object).isClosed()) {
                ((DatagramSocket)object).send(datagramPacket);
            }
        }
    }

    public void startAnnouncer() {
        new Announcer(this).start(this.timer);
    }

    public void startTextAnnouncer() {
        new TextAnnouncer(this).start(this.timer);
    }

    public void startRenewer() {
        new Renewer(this).start(this.timer);
    }

    public void schedule(TimerTask timerTask, int n) {
        this.timer.schedule(timerTask, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() {
        logger.finer("recover()");
        if (DNSState.CANCELED != this.getState()) {
            JmDNSImpl jmDNSImpl = this;
            synchronized (jmDNSImpl) {
                logger.finer("recover() Cleanning up");
                this.setState(DNSState.CANCELED);
                ArrayList arrayList = new ArrayList(this.getServices().values());
                this.unregisterAllServices();
                this.disposeServiceCollectors();
                this.closeMulticastSocket();
                this.cache.clear();
                logger.finer("recover() All is clean");
                try {
                    this.openMulticastSocket(this.getLocalHost());
                    this.start(arrayList);
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "recover() Start services exception ", exception);
                }
                logger.log(Level.WARNING, "recover() We are back!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.getState() != DNSState.CANCELED) {
            JmDNSImpl jmDNSImpl = this;
            synchronized (jmDNSImpl) {
                this.setState(DNSState.CANCELED);
                this.unregisterAllServices();
                this.disposeServiceCollectors();
                this.closeMulticastSocket();
                this.timer.cancel();
                if (this.shutdown != null) {
                    Runtime.getRuntime().removeShutdownHook(this.shutdown);
                }
            }
        }
    }

    void print() {
        System.out.println("---- cache ----");
        this.cache.print();
        System.out.println();
    }

    @Override
    public void printServices() {
        System.err.println(this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t---- Services -----");
        if (this.services != null) {
            for (Object object : this.services.keySet()) {
                stringBuffer.append("\n\t\tService: " + object + ": " + this.services.get(object));
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append("\t---- Types ----");
        if (this.serviceTypes != null) {
            for (Object object : this.serviceTypes.keySet()) {
                stringBuffer.append("\n\t\tType: " + object + ": " + this.serviceTypes.get(object));
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.cache.toString());
        stringBuffer.append("\n");
        stringBuffer.append("\t---- Service Collectors ----");
        if (this.serviceCollectors != null) {
            HashMap hashMap = this.serviceCollectors;
            synchronized (hashMap) {
                for (Object e : this.serviceCollectors.keySet()) {
                    stringBuffer.append("\n\t\tService Collector: " + e + ": " + this.serviceCollectors.get(e));
                }
                this.serviceCollectors.clear();
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInfo[] list(String string) {
        boolean bl;
        ServiceCollector serviceCollector;
        HashMap hashMap = this.serviceCollectors;
        synchronized (hashMap) {
            serviceCollector = (ServiceCollector)this.serviceCollectors.get(string);
            if (serviceCollector == null) {
                serviceCollector = new ServiceCollector(string);
                this.serviceCollectors.put(string, serviceCollector);
                this.addServiceListener(string, serviceCollector);
                bl = true;
            } else {
                bl = false;
            }
        }
        if (bl) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return serviceCollector.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeServiceCollectors() {
        logger.finer("disposeServiceCollectors()");
        HashMap hashMap = this.serviceCollectors;
        synchronized (hashMap) {
            for (ServiceCollector serviceCollector : this.serviceCollectors.values()) {
                this.removeServiceListener(serviceCollector.type, serviceCollector);
            }
            this.serviceCollectors.clear();
        }
    }

    private static String toUnqualifiedName(String string, String string2) {
        if (string2.endsWith(string)) {
            return string2.substring(0, string2.length() - string.length() - 1);
        }
        return string2;
    }

    public void setState(DNSState dNSState) {
        this.state = dNSState;
    }

    public void setTask(TimerTask timerTask) {
        this.task = timerTask;
    }

    public TimerTask getTask() {
        return this.task;
    }

    public Map getServices() {
        return this.services;
    }

    public void setLastThrottleIncrement(long l) {
        this.lastThrottleIncrement = l;
    }

    public long getLastThrottleIncrement() {
        return this.lastThrottleIncrement;
    }

    public void setThrottle(int n) {
        this.throttle = n;
    }

    public int getThrottle() {
        return this.throttle;
    }

    public static Random getRandom() {
        return random;
    }

    public void setIoLock(Object object) {
        this.ioLock = object;
    }

    public Object getIoLock() {
        return this.ioLock;
    }

    public void setPlannedAnswer(DNSIncoming dNSIncoming) {
        this.plannedAnswer = dNSIncoming;
    }

    public DNSIncoming getPlannedAnswer() {
        return this.plannedAnswer;
    }

    void setLocalHost(HostInfo hostInfo) {
        this.localHost = hostInfo;
    }

    public Map getServiceTypes() {
        return this.serviceTypes;
    }

    public void setClosed(boolean bl) {
        this.closed = bl;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public MulticastSocket getSocket() {
        return this.socket;
    }

    public InetAddress getGroup() {
        return this.group;
    }

    private static class ServiceCollector
    implements ServiceListener {
        private static Logger logger = Logger.getLogger(ServiceCollector.class.getName());
        private final Map infos = Collections.synchronizedMap(new HashMap());
        public String type;

        public ServiceCollector(String string) {
            this.type = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceAdded(ServiceEvent serviceEvent) {
            Map map = this.infos;
            synchronized (map) {
                serviceEvent.getDNS().requestServiceInfo(serviceEvent.getType(), serviceEvent.getName(), 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceRemoved(ServiceEvent serviceEvent) {
            Map map = this.infos;
            synchronized (map) {
                this.infos.remove(serviceEvent.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceResolved(ServiceEvent serviceEvent) {
            Map map = this.infos;
            synchronized (map) {
                this.infos.put(serviceEvent.getName(), serviceEvent.getInfo());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServiceInfoImpl[] list() {
            Map map = this.infos;
            synchronized (map) {
                return this.infos.values().toArray(new ServiceInfoImpl[this.infos.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Map map = this.infos;
            synchronized (map) {
                for (Object k : this.infos.keySet()) {
                    stringBuffer.append("\n\t\tService: " + k + ": " + this.infos.get(k));
                }
            }
            return stringBuffer.toString();
        }
    }

    private class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        @Override
        public void run() {
            JmDNSImpl.this.shutdown = null;
            JmDNSImpl.this.close();
        }
    }
}

