/*
 * Decompiled with CFR 0.152.
 */
package org.jmdns.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jmdns.impl.DNSIncoming;
import org.jmdns.impl.DNSState;
import org.jmdns.impl.JmDNSImpl;

class SocketListener
implements Runnable {
    static Logger logger = Logger.getLogger(SocketListener.class.getName());
    private final JmDNSImpl jmDNSImpl;

    SocketListener(JmDNSImpl jmDNSImpl) {
        this.jmDNSImpl = jmDNSImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block12: {
            try {
                byte[] byArray = new byte[8972];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                while (this.jmDNSImpl.getState() != DNSState.CANCELED) {
                    datagramPacket.setLength(byArray.length);
                    this.jmDNSImpl.getSocket().receive(datagramPacket);
                    if (this.jmDNSImpl.getState() != DNSState.CANCELED) {
                        try {
                            if (this.jmDNSImpl.getLocalHost().shouldIgnorePacket(datagramPacket)) continue;
                            DNSIncoming dNSIncoming = new DNSIncoming(datagramPacket);
                            logger.finest("SocketListener.run() JmDNS in:" + dNSIncoming.print(true));
                            Object object = this.jmDNSImpl.getIoLock();
                            synchronized (object) {
                                if (dNSIncoming.isQuery()) {
                                    if (datagramPacket.getPort() != 5353) {
                                        this.jmDNSImpl.handleQuery(dNSIncoming, datagramPacket.getAddress(), datagramPacket.getPort());
                                    }
                                    this.jmDNSImpl.handleQuery(dNSIncoming, this.jmDNSImpl.getGroup(), 5353);
                                } else {
                                    this.jmDNSImpl.handleResponse(dNSIncoming);
                                }
                                continue;
                            }
                        }
                        catch (IOException iOException) {
                            logger.log(Level.WARNING, "run() exception ", iOException);
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                if (this.jmDNSImpl.getState() == DNSState.CANCELED) break block12;
                logger.log(Level.WARNING, "run() exception ", iOException);
                this.jmDNSImpl.recover();
            }
        }
    }
}

