/*
 * Decompiled with CFR 0.152.
 */
package org.jmdns.impl.tasks;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jmdns.impl.DNSOutgoing;
import org.jmdns.impl.DNSQuestion;
import org.jmdns.impl.DNSRecord;
import org.jmdns.impl.DNSState;
import org.jmdns.impl.JmDNSImpl;
import org.jmdns.impl.ServiceInfoImpl;

public class ServiceResolver
extends TimerTask {
    static Logger logger = Logger.getLogger(ServiceResolver.class.getName());
    private final JmDNSImpl jmDNSImpl;
    int count = 0;
    private String type;

    public ServiceResolver(JmDNSImpl jmDNSImpl, String string) {
        this.jmDNSImpl = jmDNSImpl;
        this.type = string;
    }

    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 225L, 225L);
    }

    @Override
    public void run() {
        try {
            if (this.jmDNSImpl.getState() == DNSState.ANNOUNCED) {
                if (this.count++ < 3) {
                    logger.finer("run() JmDNS querying service");
                    long l = System.currentTimeMillis();
                    DNSOutgoing dNSOutgoing = new DNSOutgoing(0);
                    dNSOutgoing.addQuestion(new DNSQuestion(this.type, 12, 1));
                    for (ServiceInfoImpl serviceInfoImpl : this.jmDNSImpl.getServices().values()) {
                        try {
                            dNSOutgoing.addAnswer(new DNSRecord.Pointer(serviceInfoImpl.getType(), 12, 1, 3600, serviceInfoImpl.getQualifiedName()), l);
                        }
                        catch (IOException iOException) {
                            break;
                        }
                    }
                    this.jmDNSImpl.send(dNSOutgoing);
                } else {
                    this.cancel();
                }
            } else if (this.jmDNSImpl.getState() == DNSState.CANCELED) {
                this.cancel();
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "run() exception ", throwable);
            this.jmDNSImpl.recover();
        }
    }
}

