/*
 * Decompiled with CFR 0.152.
 */
package org.jmdns.impl.tasks;

import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jmdns.impl.DNSOutgoing;
import org.jmdns.impl.DNSQuestion;
import org.jmdns.impl.DNSRecord;
import org.jmdns.impl.DNSState;
import org.jmdns.impl.JmDNSImpl;

public class TypeResolver
extends TimerTask {
    static Logger logger = Logger.getLogger(TypeResolver.class.getName());
    private final JmDNSImpl jmDNSImpl;
    int count = 0;

    public TypeResolver(JmDNSImpl jmDNSImpl) {
        this.jmDNSImpl = jmDNSImpl;
    }

    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 225L, 225L);
    }

    @Override
    public void run() {
        try {
            if (this.jmDNSImpl.getState() == DNSState.ANNOUNCED) {
                if (this.count++ < 3) {
                    logger.finer("run() JmDNS querying type");
                    DNSOutgoing dNSOutgoing = new DNSOutgoing(0);
                    dNSOutgoing.addQuestion(new DNSQuestion("_services._mdns._udp.local.", 12, 1));
                    Iterator iterator = this.jmDNSImpl.getServiceTypes().values().iterator();
                    while (iterator.hasNext()) {
                        dNSOutgoing.addAnswer(new DNSRecord.Pointer("_services._mdns._udp.local.", 12, 1, 3600, (String)iterator.next()), 0L);
                    }
                    this.jmDNSImpl.send(dNSOutgoing);
                } else {
                    this.cancel();
                }
            } else if (this.jmDNSImpl.getState() == DNSState.CANCELED) {
                this.cancel();
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "run() exception ", throwable);
            this.jmDNSImpl.recover();
        }
    }
}

