/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.iocipher;

import info.guardianproject.iocipher.File;
import info.guardianproject.iocipher.FileDescriptor;
import info.guardianproject.iocipher.IOCipherFileChannel;
import info.guardianproject.libcore.io.IoBridge;
import info.guardianproject.libcore.io.IoUtils;
import info.guardianproject.libcore.io.OsConstants;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileInputStream
extends InputStream
implements Closeable {
    private FileDescriptor fd;
    private final boolean shouldClose;
    private IOCipherFileChannel channel;

    public FileInputStream(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        this.fd = IoBridge.open(file.getAbsolutePath(), OsConstants.O_RDONLY);
        this.getChannel();
        this.shouldClose = true;
    }

    public FileInputStream(FileDescriptor fd) {
        if (fd == null) {
            throw new NullPointerException("fd == null");
        }
        this.fd = fd;
        this.getChannel();
        this.shouldClose = false;
    }

    public FileInputStream(String path) throws FileNotFoundException {
        this(new File(path));
    }

    public int available() throws IOException {
        long value = this.channel.size() - this.channel.position();
        if (value < 0L) {
            value = 0L;
        }
        return (int)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        FileInputStream fileInputStream = this;
        synchronized (fileInputStream) {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.shouldClose) {
                IoUtils.close(this.fd);
            } else {
                this.fd = new FileDescriptor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws IOException {
        try {
            this.close();
        }
        finally {
            try {
                super.finalize();
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOCipherFileChannel getChannel() {
        FileInputStream fileInputStream = this;
        synchronized (fileInputStream) {
            if (this.channel == null) {
                this.channel = new IOCipherFileChannel(this, this.fd, OsConstants.O_RDONLY);
            }
            return this.channel;
        }
    }

    public final FileDescriptor getFD() throws IOException {
        return this.fd;
    }

    public static int readSingleByte(InputStream in) throws IOException {
        byte[] buffer = new byte[1];
        int result = in.read(buffer, 0, 1);
        return result != -1 ? buffer[0] & 0xFF : -1;
    }

    public int read() throws IOException {
        return FileInputStream.readSingleByte(this);
    }

    public int read(byte[] b) throws IOException {
        return IoBridge.read(this.fd, b, 0, b.length);
    }

    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        return IoBridge.read(this.fd, buffer, byteOffset, byteCount);
    }

    public long skip(long byteCount) throws IOException {
        if (byteCount < 0L) {
            throw new IOException("byteCount < 0: " + byteCount);
        }
        long before = this.channel.position();
        long after = this.channel.lseek(byteCount, OsConstants.SEEK_CUR);
        return after - before;
    }
}

