/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.iocipher;

import info.guardianproject.iocipher.File;
import info.guardianproject.iocipher.FileDescriptor;
import info.guardianproject.iocipher.IOCipherFileChannel;
import info.guardianproject.libcore.io.IoBridge;
import info.guardianproject.libcore.io.IoUtils;
import info.guardianproject.libcore.io.OsConstants;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

public class FileOutputStream
extends OutputStream
implements Closeable {
    private FileDescriptor fd;
    private final boolean shouldClose;
    private IOCipherFileChannel channel;
    private final int mode;

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean append) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        this.mode = OsConstants.O_WRONLY | OsConstants.O_CREAT | (append ? OsConstants.O_APPEND : OsConstants.O_TRUNC);
        this.fd = IoBridge.open(file.getAbsolutePath(), this.mode);
        this.channel = new IOCipherFileChannel(this, this.fd, this.mode);
        this.shouldClose = true;
    }

    public FileOutputStream(FileDescriptor fd) {
        if (fd == null) {
            throw new NullPointerException("fd == null");
        }
        this.fd = fd;
        this.shouldClose = false;
        this.mode = OsConstants.O_WRONLY;
        this.channel = new IOCipherFileChannel(this, fd, this.mode);
    }

    public FileOutputStream(String path) throws FileNotFoundException {
        this(path, false);
    }

    public FileOutputStream(String path, boolean append) throws FileNotFoundException {
        this(new File(path), append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        FileOutputStream fileOutputStream = this;
        synchronized (fileOutputStream) {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.shouldClose) {
                IoUtils.close(this.fd);
            } else {
                this.fd = new FileDescriptor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws IOException {
        try {
            this.close();
        }
        finally {
            try {
                super.finalize();
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOCipherFileChannel getChannel() {
        FileOutputStream fileOutputStream = this;
        synchronized (fileOutputStream) {
            if (this.channel == null) {
                this.channel = new IOCipherFileChannel(this, this.fd, this.mode);
            }
            return this.channel;
        }
    }

    public final FileDescriptor getFD() throws IOException {
        return this.fd;
    }

    public void write(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        IoBridge.write(this.fd, buffer, byteOffset, byteCount, this.mode);
    }

    public void write(int oneByte) throws IOException {
        this.write(new byte[]{(byte)oneByte}, 0, 1);
    }
}

