/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.iocipher;

import info.guardianproject.iocipher.FileDescriptor;
import info.guardianproject.libcore.io.ErrnoException;
import info.guardianproject.libcore.io.Libcore;
import info.guardianproject.libcore.io.OsConstants;
import info.guardianproject.libcore.io.StructStat;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class IOCipherFileChannel
extends AbstractInterruptibleChannel
implements ByteChannel {
    private final Object stream;
    private final FileDescriptor fd;
    private final int mode;

    public IOCipherFileChannel(Object stream, FileDescriptor fd, int mode) {
        this.fd = fd;
        this.stream = stream;
        this.mode = mode;
    }

    private void checkOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private void checkReadable() {
        if ((this.mode & OsConstants.O_ACCMODE) == OsConstants.O_WRONLY) {
            throw new NonReadableChannelException();
        }
    }

    private void checkWritable() {
        if ((this.mode & OsConstants.O_ACCMODE) == OsConstants.O_RDONLY) {
            throw new NonWritableChannelException();
        }
    }

    protected void implCloseChannel() throws IOException {
        if (this.stream instanceof Closeable) {
            ((Closeable)this.stream).close();
        }
    }

    public void force(boolean metadata) throws IOException {
        this.checkOpen();
        if ((this.mode & OsConstants.O_ACCMODE) != OsConstants.O_RDONLY) {
            try {
                Libcore.os.fsync(this.fd);
            }
            catch (ErrnoException errnoException) {
                throw errnoException.rethrowAsIOException();
            }
        }
    }

    public long lseek(long offset, int whence) throws IOException {
        this.checkOpen();
        long tmpPosition = this.fd.position;
        if (whence == OsConstants.SEEK_SET) {
            tmpPosition = offset;
        } else if (whence == OsConstants.SEEK_CUR) {
            tmpPosition += offset;
        } else if (whence == OsConstants.SEEK_END) {
            tmpPosition = this.size() + offset;
        } else {
            throw new IllegalArgumentException("Unknown 'whence': " + whence);
        }
        if (tmpPosition < 0L) {
            throw new IOException("negative resulting position: " + tmpPosition);
        }
        this.fd.position = tmpPosition;
        return this.fd.position;
    }

    public long position() throws IOException {
        this.checkOpen();
        return this.fd.position;
    }

    public IOCipherFileChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("negative file position not allowed: " + newPosition);
        }
        this.checkOpen();
        this.fd.position = newPosition;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readImpl(ByteBuffer buffer, long position) throws IOException {
        if (buffer.isReadOnly()) {
            throw new IllegalArgumentException("read-only buffer");
        }
        this.checkOpen();
        this.checkReadable();
        if (!buffer.hasRemaining()) {
            return 0;
        }
        int bytesRead = 0;
        boolean completed = false;
        try {
            this.begin();
            try {
                bytesRead = position == -1L ? Libcore.os.read(this.fd, buffer) : Libcore.os.pread(this.fd, buffer, position);
                if (bytesRead == 0) {
                    bytesRead = -1;
                }
            }
            catch (ErrnoException errnoException) {
                if (errnoException.errno == OsConstants.EAGAIN) {
                    bytesRead = 0;
                }
                throw errnoException.rethrowAsIOException();
            }
            completed = true;
            this.end(completed && bytesRead >= 0);
        }
        catch (Throwable throwable) {
            this.end(completed && bytesRead >= 0);
            throw throwable;
        }
        if (bytesRead > 0) {
            buffer.position(buffer.position() + bytesRead);
        }
        return bytesRead;
    }

    public int read(ByteBuffer buffer) throws IOException {
        return this.readImpl(buffer, -1L);
    }

    public int read(ByteBuffer buffer, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("negative file position not allowed: " + position);
        }
        return this.readImpl(buffer, position);
    }

    public long size() throws IOException {
        try {
            StructStat sb = Libcore.os.fstat(this.fd);
            return sb.st_size;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeImpl(ByteBuffer buffer, long position) throws IOException {
        this.checkOpen();
        this.checkWritable();
        if (buffer == null) {
            throw new NullPointerException("buffer == null");
        }
        if (!buffer.hasRemaining()) {
            return 0;
        }
        int bytesWritten = 0;
        boolean completed = false;
        try {
            this.begin();
            try {
                bytesWritten = position == -1L ? Libcore.os.write(this.fd, buffer, this.mode) : Libcore.os.pwrite(this.fd, buffer, position, this.mode);
            }
            catch (ErrnoException errnoException) {
                throw errnoException.rethrowAsIOException();
            }
            completed = true;
        }
        finally {
            this.end(completed);
        }
        if (bytesWritten > 0) {
            buffer.position(buffer.position() + bytesWritten);
        }
        return bytesWritten;
    }

    public int write(ByteBuffer src) throws IOException {
        return this.writeImpl(src, -1L);
    }

    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        this.checkOpen();
        if (!src.isOpen()) {
            throw new ClosedChannelException();
        }
        this.checkWritable();
        if (position < 0L || count < 0L || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("position=" + position + " count=" + count);
        }
        if (position > this.size()) {
            return 0L;
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)count);
        src.read(buffer);
        buffer.flip();
        return this.write(buffer, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        this.checkOpen();
        if (!target.isOpen()) {
            throw new ClosedChannelException();
        }
        this.checkReadable();
        if (target instanceof IOCipherFileChannel) {
            ((IOCipherFileChannel)target).checkWritable();
        }
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException("position=" + position + " count=" + count);
        }
        if (count == 0L || position >= this.size()) {
            return 0L;
        }
        count = Math.min(count, this.size() - position);
        ByteBuffer buffer = ByteBuffer.allocate((int)count);
        this.read(buffer, position);
        buffer.flip();
        long l = target.write(buffer);
        return l;
    }

    public IOCipherFileChannel truncate(long size) throws IOException {
        this.checkOpen();
        if (size < 0L) {
            throw new IllegalArgumentException("size: " + size);
        }
        this.checkWritable();
        if (size < this.size()) {
            try {
                Libcore.os.ftruncate(this.fd, size);
            }
            catch (ErrnoException errnoException) {
                throw errnoException.rethrowAsIOException();
            }
        }
        return this;
    }

    public int write(ByteBuffer buffer, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position: " + position);
        }
        return this.writeImpl(buffer, position);
    }
}

