/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.iocipher;

import info.guardianproject.iocipher.File;
import info.guardianproject.iocipher.FileDescriptor;
import info.guardianproject.iocipher.IOCipherFileChannel;
import info.guardianproject.libcore.io.ErrnoException;
import info.guardianproject.libcore.io.IoBridge;
import info.guardianproject.libcore.io.IoUtils;
import info.guardianproject.libcore.io.Libcore;
import info.guardianproject.libcore.io.Memory;
import info.guardianproject.libcore.io.OsConstants;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;

public class RandomAccessFile
implements DataInput,
DataOutput,
Closeable {
    private FileDescriptor fd;
    private boolean syncMetadata = false;
    private IOCipherFileChannel channel;
    private int mode;
    private final byte[] scratch = new byte[8];

    public RandomAccessFile(File file, String mode) throws FileNotFoundException {
        int flags;
        if (mode.equals("r")) {
            flags = OsConstants.O_RDONLY;
        } else if (mode.equals("rw") || mode.equals("rws") || mode.equals("rwd")) {
            flags = OsConstants.O_RDWR | OsConstants.O_CREAT;
            if (mode.equals("rws")) {
                this.syncMetadata = true;
            } else if (mode.equals("rwd")) {
                flags |= OsConstants.O_SYNC;
            }
        } else {
            throw new IllegalArgumentException("Invalid mode: " + mode);
        }
        this.mode = flags;
        this.fd = IoBridge.open(file.getAbsolutePath(), flags);
        this.channel = new IOCipherFileChannel(this, this.fd, this.mode);
        if (this.syncMetadata) {
            try {
                this.fd.sync();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public RandomAccessFile(String fileName, String mode) throws FileNotFoundException {
        this(new File(fileName), mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        RandomAccessFile randomAccessFile = this;
        synchronized (randomAccessFile) {
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close();
                this.channel = null;
            }
            IoUtils.close(this.fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public final synchronized IOCipherFileChannel getChannel() {
        if (this.channel == null) {
            this.channel = new IOCipherFileChannel(this, this.fd, this.mode);
        }
        return this.channel;
    }

    public final FileDescriptor getFD() throws IOException {
        return this.fd;
    }

    public long getFilePointer() throws IOException {
        return this.fd.position;
    }

    public long length() throws IOException {
        try {
            return Libcore.os.fstat((FileDescriptor)this.fd).st_size;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public int read() throws IOException {
        return this.read(this.scratch, 0, 1) != -1 ? this.scratch[0] & 0xFF : -1;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        return IoBridge.read(this.fd, buffer, byteOffset, byteCount);
    }

    public final boolean readBoolean() throws IOException {
        int temp = this.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return temp != 0;
    }

    public final byte readByte() throws IOException {
        int temp = this.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return (byte)temp;
    }

    public final char readChar() throws IOException {
        return (char)this.readShort();
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFully(byte[] dst) throws IOException {
        this.readFully(dst, 0, dst.length);
    }

    public final void readFully(byte[] dst, int offset, int byteCount) throws IOException {
        IoBridge.checkOffsetAndCount(dst.length, offset, byteCount);
        while (byteCount > 0) {
            int result = this.read(dst, offset, byteCount);
            if (result < 0) {
                throw new EOFException();
            }
            offset += result;
            byteCount -= result;
        }
    }

    public final int readInt() throws IOException {
        this.readFully(this.scratch, 0, 4);
        return Memory.peekInt(this.scratch, 0, ByteOrder.BIG_ENDIAN);
    }

    public final String readLine() throws IOException {
        StringBuilder line = new StringBuilder(80);
        boolean foundTerminator = false;
        long unreadPosition = 0L;
        block5: while (true) {
            int nextByte = this.read();
            switch (nextByte) {
                case -1: {
                    return line.length() != 0 ? line.toString() : null;
                }
                case 13: {
                    if (foundTerminator) {
                        this.seek(unreadPosition);
                        return line.toString();
                    }
                    foundTerminator = true;
                    unreadPosition = this.getFilePointer();
                    continue block5;
                }
                case 10: {
                    return line.toString();
                }
            }
            if (foundTerminator) {
                this.seek(unreadPosition);
                return line.toString();
            }
            line.append((char)nextByte);
        }
    }

    public final long readLong() throws IOException {
        this.readFully(this.scratch, 0, 8);
        return Memory.peekLong(this.scratch, 0, ByteOrder.BIG_ENDIAN);
    }

    public final short readShort() throws IOException {
        this.readFully(this.scratch, 0, 2);
        return Memory.peekShort(this.scratch, 0, ByteOrder.BIG_ENDIAN);
    }

    public final int readUnsignedByte() throws IOException {
        int temp = this.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return temp;
    }

    public final int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public final String readUTF() throws IOException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void seek(long offset) throws IOException {
        if (offset < 0L) {
            throw new IOException("offset < 0: " + offset);
        }
        this.channel.lseek(offset, OsConstants.SEEK_SET);
    }

    public void setLength(long newLength) throws IOException {
        if (newLength < 0L) {
            throw new IllegalArgumentException("newLength < 0");
        }
        try {
            Libcore.os.ftruncate(this.fd, newLength);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
        long filePointer = this.getFilePointer();
        if (filePointer > newLength) {
            this.seek(newLength);
        }
        if (this.syncMetadata) {
            this.fd.sync();
        }
    }

    public int skipBytes(int count) throws IOException {
        if (count > 0) {
            long eof;
            long currentPos = this.getFilePointer();
            int newCount = (int)(currentPos + (long)count > (eof = this.length()) ? eof - currentPos : (long)count);
            this.seek(currentPos + (long)newCount);
            return newCount;
        }
        return 0;
    }

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        IoBridge.write(this.fd, buffer, byteOffset, byteCount, this.mode);
        if (this.syncMetadata) {
            this.fd.sync();
        }
    }

    public void write(int oneByte) throws IOException {
        this.scratch[0] = (byte)(oneByte & 0xFF);
        this.write(this.scratch, 0, 1);
    }

    public final void writeBoolean(boolean val) throws IOException {
        this.write(val ? 1 : 0);
    }

    public final void writeByte(int val) throws IOException {
        this.write(val & 0xFF);
    }

    public final void writeBytes(String str) throws IOException {
        byte[] bytes = new byte[str.length()];
        for (int index = 0; index < str.length(); ++index) {
            bytes[index] = (byte)(str.charAt(index) & 0xFF);
        }
        this.write(bytes);
    }

    public final void writeChar(int val) throws IOException {
        this.writeShort(val);
    }

    public final void writeChars(String str) throws IOException {
        this.write(str.getBytes("UTF-16BE"));
    }

    public final void writeDouble(double val) throws IOException {
        this.writeLong(Double.doubleToLongBits(val));
    }

    public final void writeFloat(float val) throws IOException {
        this.writeInt(Float.floatToIntBits(val));
    }

    public final void writeInt(int val) throws IOException {
        Memory.pokeInt(this.scratch, 0, val, ByteOrder.BIG_ENDIAN);
        this.write(this.scratch, 0, 4);
    }

    public final void writeLong(long val) throws IOException {
        Memory.pokeLong(this.scratch, 0, val, ByteOrder.BIG_ENDIAN);
        this.write(this.scratch, 0, 8);
    }

    public final void writeShort(int val) throws IOException {
        Memory.pokeShort(this.scratch, 0, (short)val, ByteOrder.BIG_ENDIAN);
        this.write(this.scratch, 0, 2);
    }

    public final void writeUTF(String str) throws IOException {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

