/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.iocipher;

import android.text.TextUtils;
import java.io.File;
import java.io.IOException;
import javax.crypto.SecretKey;

public class VirtualFileSystem {
    private static String dbFileName = "";
    private static VirtualFileSystem vfs;

    private VirtualFileSystem() {
    }

    public static VirtualFileSystem get() {
        if (vfs == null) {
            vfs = new VirtualFileSystem();
        }
        return vfs;
    }

    public void setContainerPath(String containerPath) {
        if (TextUtils.isEmpty((CharSequence)containerPath)) {
            throw new IllegalArgumentException("blank file name not allowed!");
        }
        File file = new File(containerPath);
        File dir = file.getParentFile();
        if (!dir.exists()) {
            throw new IllegalArgumentException(dir.getPath() + " does not exist!");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir.getPath() + " is not a directory!");
        }
        if (!dir.canWrite()) {
            throw new IllegalArgumentException("Cannot write to " + dir.getPath() + "!");
        }
        try {
            dbFileName = file.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            dbFileName = file.getAbsolutePath();
        }
    }

    public String getContainerPath() {
        return dbFileName;
    }

    public native void mount_unencrypted() throws IllegalArgumentException;

    public void mount_unencrypted(String containerPath) {
        this.setContainerPath(containerPath);
        this.mount_unencrypted();
    }

    public native void mount(String var1) throws IllegalArgumentException;

    public void mount(String containerPath, String password) {
        this.setContainerPath(containerPath);
        this.mount(password);
    }

    public native void mount(byte[] var1) throws IllegalArgumentException;

    public void mount(String containerPath, byte[] key) {
        this.setContainerPath(containerPath);
        this.mount(key);
    }

    public void mount(SecretKey key) {
        this.mount(key.getEncoded());
    }

    public void mount(String containerPath, SecretKey key) {
        this.setContainerPath(containerPath);
        this.mount(key);
    }

    public native void unmount() throws IllegalStateException;

    public native boolean isMounted();

    public native void beginTransaction();

    public native void completeTransaction();

    static {
        System.loadLibrary("stlport_shared");
        System.loadLibrary("sqlcipher_android");
        System.loadLibrary("iocipher");
    }
}

