/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.libcore.io;

import info.guardianproject.iocipher.FileDescriptor;
import info.guardianproject.libcore.io.ErrnoException;
import info.guardianproject.libcore.io.IoUtils;
import info.guardianproject.libcore.io.Libcore;
import info.guardianproject.libcore.io.OsConstants;
import java.io.FileNotFoundException;
import java.io.IOException;

public final class IoBridge {
    private IoBridge() {
    }

    public static void checkOffsetAndCount(int arrayLength, int offset, int count) {
        if ((offset | count) < 0 || offset > arrayLength || arrayLength - offset < count) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static FileDescriptor open(String path, int flags) throws FileNotFoundException {
        FileDescriptor fd = null;
        try {
            int mode = (flags & OsConstants.O_ACCMODE) == OsConstants.O_RDONLY ? 0 : 384;
            fd = Libcore.os.open(path, flags, mode);
            if (fd.valid() && OsConstants.S_ISDIR(Libcore.os.fstat((FileDescriptor)fd).st_mode)) {
                throw new ErrnoException("open", OsConstants.EISDIR);
            }
            return fd;
        }
        catch (ErrnoException errnoException) {
            try {
                if (fd != null) {
                    IoUtils.close(fd);
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            FileNotFoundException ex = new FileNotFoundException(path + ": " + errnoException.getMessage());
            ex.initCause(errnoException);
            throw ex;
        }
    }

    public static int read(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws IOException {
        IoBridge.checkOffsetAndCount(bytes.length, byteOffset, byteCount);
        if (byteCount == 0) {
            return 0;
        }
        try {
            int readCount = Libcore.os.read(fd, bytes, byteOffset, byteCount);
            if (readCount == 0) {
                return -1;
            }
            return readCount;
        }
        catch (ErrnoException errnoException) {
            if (errnoException.errno == OsConstants.EAGAIN) {
                return 0;
            }
            throw errnoException.rethrowAsIOException();
        }
    }

    public static void write(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags) throws IOException {
        IoBridge.checkOffsetAndCount(bytes.length, byteOffset, byteCount);
        if (byteCount == 0) {
            return;
        }
        try {
            while (byteCount > 0) {
                int bytesWritten = Libcore.os.write(fd, bytes, byteOffset, byteCount, flags);
                byteCount -= bytesWritten;
                byteOffset += bytesWritten;
            }
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }
}

