/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.libcore.io;

import info.guardianproject.iocipher.FileDescriptor;
import info.guardianproject.libcore.io.ErrnoException;
import info.guardianproject.libcore.io.Libcore;
import info.guardianproject.libcore.io.OsConstants;
import java.io.File;
import java.io.IOException;
import java.net.Socket;

public final class IoUtils {
    private IoUtils() {
    }

    public static void close(FileDescriptor fd) throws IOException {
        try {
            if (fd != null && fd.valid()) {
                Libcore.os.close(fd);
            }
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public static void closeQuietly(FileDescriptor fd) {
        try {
            IoUtils.close(fd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setBlocking(FileDescriptor fd, boolean blocking) throws IOException {
        try {
            int flags = Libcore.os.fcntlVoid(fd, OsConstants.F_GETFL);
            flags = !blocking ? (flags |= OsConstants.O_NONBLOCK) : (flags &= ~OsConstants.O_NONBLOCK);
            Libcore.os.fcntlLong(fd, OsConstants.F_SETFL, flags);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public static void deleteContents(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("not a directory: " + dir);
        }
        for (File file : files) {
            if (file.isDirectory()) {
                IoUtils.deleteContents(file);
            }
            if (file.delete()) continue;
            throw new IOException("failed to delete file: " + file);
        }
    }
}

