/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.libcore.io;

import info.guardianproject.iocipher.FileDescriptor;
import info.guardianproject.libcore.io.ErrnoException;
import info.guardianproject.libcore.io.Os;
import info.guardianproject.libcore.io.StructFlock;
import info.guardianproject.libcore.io.StructPasswd;
import info.guardianproject.libcore.io.StructPollfd;
import info.guardianproject.libcore.io.StructStat;
import info.guardianproject.libcore.io.StructStatFs;
import info.guardianproject.libcore.io.StructUtsname;
import java.nio.ByteBuffer;

public final class Posix
implements Os {
    Posix() {
    }

    public native boolean access(String var1, int var2) throws ErrnoException;

    public native void chmod(String var1, int var2) throws ErrnoException;

    public native void close(FileDescriptor var1) throws ErrnoException;

    public native void fsync(FileDescriptor var1) throws ErrnoException;

    public native void ftruncate(FileDescriptor var1, long var2) throws ErrnoException;

    public native void link(String var1, String var2) throws ErrnoException;

    public native void mkdir(String var1, int var2) throws ErrnoException;

    public native FileDescriptor open(String var1, int var2, int var3) throws ErrnoException;

    private native int preadBytes(FileDescriptor var1, Object var2, int var3, int var4, long var5) throws ErrnoException;

    public int pread(FileDescriptor fd, ByteBuffer buffer, long offset) throws ErrnoException {
        if (buffer.isDirect()) {
            return this.preadBytes(fd, buffer, buffer.position(), buffer.remaining(), offset);
        }
        return this.preadBytes(fd, buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining(), offset);
    }

    public int pread(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, long offset) throws ErrnoException {
        return this.preadBytes(fd, bytes, byteOffset, byteCount, offset);
    }

    public int read(FileDescriptor fd, ByteBuffer buffer) throws ErrnoException {
        int ret = buffer.isDirect() ? this.preadBytes(fd, buffer, buffer.position(), buffer.remaining(), 0L) : this.preadBytes(fd, buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining(), 0L);
        fd.position += (long)ret;
        return ret;
    }

    public int read(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws ErrnoException {
        int ret = this.preadBytes(fd, bytes, byteOffset, byteCount, fd.position);
        fd.position += (long)byteCount;
        return ret;
    }

    public native void remove(String var1) throws ErrnoException;

    public native void rename(String var1, String var2) throws ErrnoException;

    public native void rmdir(String var1) throws ErrnoException;

    public native StructStatFs statfs(String var1) throws ErrnoException;

    public StructStatFs fstatfs(FileDescriptor fd) throws ErrnoException {
        return this.statfs("");
    }

    public native String strerror(int var1);

    public native void symlink(String var1, String var2) throws ErrnoException;

    public native void unlink(String var1) throws ErrnoException;

    public int write(FileDescriptor fd, ByteBuffer buffer, int flags) throws ErrnoException {
        int ret = buffer.isDirect() ? this.pwriteBytes(fd, buffer, buffer.position(), buffer.remaining(), 0L, flags) : this.pwriteBytes(fd, buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining(), 0L, flags);
        fd.position += (long)ret;
        return ret;
    }

    public int write(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags) throws ErrnoException {
        int ret = this.pwriteBytes(fd, bytes, byteOffset, byteCount, fd.position, flags);
        fd.position += (long)byteCount;
        return ret;
    }

    public int pwrite(FileDescriptor fd, ByteBuffer buffer, long offset, int flags) throws ErrnoException {
        if (buffer.isDirect()) {
            return this.pwriteBytes(fd, buffer, buffer.position(), buffer.remaining(), offset, flags);
        }
        return this.pwriteBytes(fd, buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining(), offset, flags);
    }

    public int pwrite(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, long offset, int flags) throws ErrnoException {
        return this.pwriteBytes(fd, bytes, byteOffset, byteCount, offset, flags);
    }

    private native int pwriteBytes(FileDescriptor var1, Object var2, int var3, int var4, long var5, int var7) throws ErrnoException;

    public native StructStat stat(String var1) throws ErrnoException;

    public native StructStat fstat(FileDescriptor var1) throws ErrnoException;

    public FileDescriptor dup(FileDescriptor oldFd) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public FileDescriptor dup2(FileDescriptor oldFd, int newFd) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String[] environ() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int fcntlVoid(FileDescriptor fd, int cmd) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int fcntlLong(FileDescriptor fd, int cmd, long arg) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int fcntlFlock(FileDescriptor fd, int cmd, StructFlock arg) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void fdatasync(FileDescriptor fd) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String gai_strerror(int error) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getegid() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int geteuid() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getgid() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getenv(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getpid() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getppid() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public StructPasswd getpwnam(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public StructPasswd getpwuid(int uid) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getuid() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int ioctlInt(FileDescriptor fd, int cmd, int arg) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isatty(FileDescriptor fd) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void kill(int pid, int signal) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void listen(FileDescriptor fd, int backlog) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public StructStat lstat(String path) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void mincore(long address, long byteCount, byte[] vector) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void mlock(long address, long byteCount) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long mmap(long address, long byteCount, int prot, int flags, FileDescriptor fd, long offset) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void msync(long address, long byteCount, int flags) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void munlock(long address, long byteCount) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void munmap(long address, long byteCount) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public FileDescriptor[] pipe() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int poll(StructPollfd[] fds, int timeoutMs) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int readv(FileDescriptor fd, Object[] buffers, int[] offsets, int[] byteCounts) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setegid(int egid) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void seteuid(int euid) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setgid(int gid) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setuid(int uid) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void shutdown(FileDescriptor fd, int how) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public FileDescriptor socket(int domain, int type, int protocol) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long sysconf(int name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public StructUtsname uname() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int waitpid(int pid, int status, int options) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int writev(FileDescriptor fd, Object[] buffers, int[] offsets, int[] byteCounts) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }
}

