/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtcrime.ssl.pinning;

import android.content.Context;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.thoughtcrime.ssl.pinning.PinningTrustManager;
import org.thoughtcrime.ssl.pinning.SystemKeyStore;

public class PinningSSLSocketFactory
extends org.apache.http.conn.ssl.SSLSocketFactory {
    private final SSLSocketFactory pinningSocketFactory;

    public PinningSSLSocketFactory(Context context, String[] pins, long enforceUntilTimestampMillis) throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        super(null);
        SystemKeyStore keyStore = SystemKeyStore.getInstance(context);
        SSLContext pinningSslContext = SSLContext.getInstance("TLS");
        TrustManager[] pinningTrustManagers = this.initializePinningTrustManagers(keyStore, pins, enforceUntilTimestampMillis);
        pinningSslContext.init(null, pinningTrustManagers, null);
        this.pinningSocketFactory = pinningSslContext.getSocketFactory();
    }

    public Socket createSocket() throws IOException {
        return this.pinningSocketFactory.createSocket();
    }

    public Socket connectSocket(Socket sock, String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException {
        SSLSocket sslSock = (SSLSocket)(sock != null ? sock : this.createSocket());
        if (localAddress != null || localPort > 0) {
            if (localPort < 0) {
                localPort = 0;
            }
            sslSock.bind(new InetSocketAddress(localAddress, localPort));
        }
        int connTimeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
        int soTimeout = HttpConnectionParams.getSoTimeout((HttpParams)params);
        InetSocketAddress remoteAddress = new InetSocketAddress(host, port);
        sslSock.connect(remoteAddress, connTimeout);
        sslSock.setSoTimeout(soTimeout);
        try {
            org.apache.http.conn.ssl.SSLSocketFactory.STRICT_HOSTNAME_VERIFIER.verify(host, sslSock);
        }
        catch (IOException iox) {
            try {
                sslSock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iox;
        }
        return sslSock;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        if (port == -1) {
            port = 443;
        }
        SSLSocket sslSocket = (SSLSocket)this.pinningSocketFactory.createSocket(socket, host, port, autoClose);
        org.apache.http.conn.ssl.SSLSocketFactory.STRICT_HOSTNAME_VERIFIER.verify(host, sslSocket);
        return sslSocket;
    }

    public void setHostnameVerifier(X509HostnameVerifier hostnameVerifier) {
        throw new IllegalArgumentException("Only strict hostname verification (default)  is supported!");
    }

    public X509HostnameVerifier getHostnameVerifier() {
        return org.apache.http.conn.ssl.SSLSocketFactory.STRICT_HOSTNAME_VERIFIER;
    }

    private TrustManager[] initializePinningTrustManagers(SystemKeyStore keyStore, String[] pins, long enforceUntilTimestampMillis) {
        TrustManager[] trustManagers = new TrustManager[]{new PinningTrustManager(keyStore, pins, enforceUntilTimestampMillis)};
        return trustManagers;
    }
}

