/*
 * Decompiled with CFR 0.152.
 */
package org.ironrabbit.type;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.ironrabbit.type.TibConvert;

public class CustomTypefaceManager {
    private static Typeface mTypeface = null;

    public static Typeface getCurrentTypeface(Context context) {
        return mTypeface;
    }

    public static void loadFromKeyboard(Context context) {
        PackageManager packageManager = context.getPackageManager();
        String fontName = "DDC_Uchen.ttf";
        try {
            Resources res = packageManager.getResourcesForApplication("org.ironrabbit.bhoboard");
            InputStream reader = res.getAssets().open(fontName);
            File fileFont = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS), fontName);
            FileOutputStream writer = new FileOutputStream(fileFont);
            byte[] buffer = new byte[32000];
            int l = 0;
            while ((l = reader.read(buffer)) > 0) {
                ((OutputStream)writer).write(buffer, 0, l);
            }
            ((OutputStream)writer).close();
            mTypeface = Typeface.createFromFile((File)fileFont);
        }
        catch (Exception e) {
            Log.e((String)"CustomTypeface", (String)"can't find assets", (Throwable)e);
        }
    }

    public static void setTypeface(Typeface typeface) {
        mTypeface = typeface;
    }

    public static void setTypefaceFromAsset(Context context, String path) {
        mTypeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)path);
    }

    public static void setTypefaceFromFile(Context context, String path) {
        File fileFont = new File(path);
        if (fileFont.exists()) {
            mTypeface = Typeface.createFromFile((File)fileFont);
        }
    }

    public static boolean precomposeRequired() {
        return Build.VERSION.SDK_INT < 17;
    }

    public static String handlePrecompose(String text) {
        if (CustomTypefaceManager.precomposeRequired()) {
            return TibConvert.convertUnicodeToPrecomposedTibetan(text);
        }
        return text;
    }
}

