/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.cacheword;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import info.guardianproject.cacheword.CacheWordService;
import info.guardianproject.cacheword.ICacheWordBinder;
import info.guardianproject.cacheword.ICacheWordSubscriber;
import info.guardianproject.cacheword.ICachedSecrets;
import info.guardianproject.cacheword.PassphraseSecrets;
import info.guardianproject.cacheword.SecretsManager;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class CacheWordHandler {
    private static final String TAG = "CacheWordHandler";
    private Context mContext;
    private CacheWordService mCacheWordService;
    private ICacheWordSubscriber mSubscriber;
    private Notification mNotification;
    private int mTimeout;
    static final int DEFAULT_TIMEOUT_SECONDS = 300;
    private ServiceConnectionState mConnectionState = ServiceConnectionState.CONNECTION_NULL;
    private BindState mBoundState = BindState.BIND_NULL;
    private BroadcastReceiver mCacheWordReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("info.guardianproject.cacheword.NEW_SECRETS") && CacheWordHandler.this.isCacheWordConnected()) {
                CacheWordHandler.this.checkCacheWordState();
            }
        }
    };
    private ServiceConnection mCacheWordServiceConnection = new ServiceConnection(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder binder) {
            ICacheWordBinder cwBinder = (ICacheWordBinder)binder;
            if (cwBinder != null) {
                Log.d((String)CacheWordHandler.TAG, (String)"onServiceConnected");
                CacheWordHandler cacheWordHandler = CacheWordHandler.this;
                synchronized (cacheWordHandler) {
                    if (CacheWordHandler.this.mConnectionState == ServiceConnectionState.CONNECTION_INPROGRESS) {
                        CacheWordHandler.this.mCacheWordService = cwBinder.getService();
                        CacheWordHandler.this.registerBroadcastReceiver();
                        CacheWordHandler.this.mCacheWordService.attachSubscriber();
                        CacheWordHandler.this.mCacheWordService.setTimeout(CacheWordHandler.this.mTimeout);
                        CacheWordHandler.this.mCacheWordService.setNotification(CacheWordHandler.this.mNotification);
                        CacheWordHandler.this.mConnectionState = ServiceConnectionState.CONNECTION_ACTIVE;
                        CacheWordHandler.this.mBoundState = BindState.BIND_COMPLETED;
                        CacheWordHandler.this.checkCacheWordState();
                    } else if (CacheWordHandler.this.mConnectionState == ServiceConnectionState.CONNECTION_CANCELED && CacheWordHandler.this.mBoundState != BindState.BIND_NULL) {
                        CacheWordHandler.this.mContext.unbindService(CacheWordHandler.this.mCacheWordServiceConnection);
                        CacheWordHandler.this.mBoundState = BindState.BIND_NULL;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName name) {
            Log.d((String)CacheWordHandler.TAG, (String)"onServiceDisonnected");
            CacheWordHandler cacheWordHandler = CacheWordHandler.this;
            synchronized (cacheWordHandler) {
                if (CacheWordHandler.this.mBoundState != BindState.BIND_NULL) {
                    CacheWordHandler.this.mContext.unbindService(CacheWordHandler.this.mCacheWordServiceConnection);
                    CacheWordHandler.this.mBoundState = BindState.BIND_NULL;
                    CacheWordHandler.this.unregisterBroadcastRecevier();
                }
                CacheWordHandler.this.mCacheWordService = null;
            }
        }
    };

    public void disconnect() {
        if (this.mCacheWordService != null) {
            this.mCacheWordService.detachSubscriber();
            this.mContext.unbindService(this.mCacheWordServiceConnection);
        }
    }

    public CacheWordHandler(Context context) {
        this(context, (ICacheWordSubscriber)context, 300);
    }

    public CacheWordHandler(Context context, ICacheWordSubscriber subscriber) {
        this(context, subscriber, 300);
    }

    public CacheWordHandler(Context context, int timeout) {
        try {
            this.mSubscriber = (ICacheWordSubscriber)context;
            this.mContext = context;
            this.mTimeout = timeout;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("CacheWordHandler passed invalid Activity. Expects class that implements ICacheWordSubscriber");
        }
    }

    public CacheWordHandler(Context context, ICacheWordSubscriber subscriber, int timeout) {
        this.mContext = context;
        this.mSubscriber = subscriber;
        this.mTimeout = timeout;
    }

    public synchronized void connectToService() {
        if (this.isCacheWordConnected()) {
            return;
        }
        Intent cacheWordIntent = CacheWordHandler.getBlankServiceIntent(this.mContext);
        this.mContext.startService(cacheWordIntent);
        if (this.mContext.bindService(cacheWordIntent, this.mCacheWordServiceConnection, 1)) {
            this.mBoundState = BindState.BIND_REQUESTED;
        }
        this.mConnectionState = ServiceConnectionState.CONNECTION_INPROGRESS;
    }

    public void detach() {
        if (this.mCacheWordService != null) {
            this.mCacheWordService.detachSubscriber();
        }
    }

    public void reattach() {
        if (this.mCacheWordService != null) {
            this.mCacheWordService.attachSubscriber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectFromService() {
        CacheWordHandler cacheWordHandler = this;
        synchronized (cacheWordHandler) {
            this.mConnectionState = ServiceConnectionState.CONNECTION_CANCELED;
            if (this.mBoundState == BindState.BIND_COMPLETED) {
                if (this.mCacheWordService != null) {
                    this.mCacheWordService.detachSubscriber();
                    this.mCacheWordService = null;
                }
                this.mContext.unbindService(this.mCacheWordServiceConnection);
                this.mBoundState = BindState.BIND_NULL;
                this.unregisterBroadcastRecevier();
            }
        }
    }

    public ICachedSecrets getCachedSecrets() {
        if (!this.isCacheWordConnected()) {
            return null;
        }
        return this.mCacheWordService.getCachedSecrets();
    }

    public byte[] getEncryptionKey() {
        ICachedSecrets s = this.getCachedSecrets();
        if (s instanceof PassphraseSecrets) {
            return ((PassphraseSecrets)s).getSecretKey().getEncoded();
        }
        return null;
    }

    public void setCachedSecrets(ICachedSecrets secrets) {
        if (!this.isCacheWordConnected()) {
            return;
        }
        this.mCacheWordService.setCachedSecrets(secrets);
    }

    public void setPassphrase(char[] passphrase) throws GeneralSecurityException {
        PassphraseSecrets ps;
        if (SecretsManager.isInitialized(this.mContext)) {
            ps = PassphraseSecrets.fetchSecrets(this.mContext, passphrase);
        } else {
            ps = PassphraseSecrets.initializeSecrets(this.mContext, passphrase);
            if (ps == null) {
                throw new GeneralSecurityException("initializeSecrets could not save the secrets.");
            }
        }
        this.setCachedSecrets(ps);
    }

    public PassphraseSecrets changePassphrase(PassphraseSecrets current_secrets, char[] new_passphrase) throws IOException {
        if (!SecretsManager.isInitialized(this.mContext)) {
            throw new IllegalStateException("CacheWord is not initialized. Passphrase can't be changed");
        }
        PassphraseSecrets new_secrets = PassphraseSecrets.changePassphrase(this.mContext, current_secrets, new_passphrase);
        if (new_secrets != null) {
            return new_secrets;
        }
        throw new IOException("changePassphrase could not save the secrets");
    }

    public void lock() {
        if (!this.isPrepared()) {
            return;
        }
        this.mCacheWordService.lock();
    }

    public boolean isLocked() {
        if (!this.isPrepared()) {
            return true;
        }
        return this.mCacheWordService.isLocked();
    }

    public void setTimeout(int seconds) throws IllegalStateException {
        if (!this.isCacheWordConnected()) {
            throw new IllegalStateException("CacheWord not connected");
        }
        this.mCacheWordService.setTimeout(seconds);
    }

    public int getTimeout() throws IllegalStateException {
        if (!this.isCacheWordConnected()) {
            throw new IllegalStateException("CacheWord not connected");
        }
        return this.mCacheWordService.getTimeout();
    }

    public void setNotification(Notification notification) {
        this.mNotification = notification;
    }

    public static Intent getBlankServiceIntent(Context context) {
        Intent i = new Intent();
        i.setClassName(context.getApplicationContext(), "info.guardianproject.cacheword.CacheWordService");
        return i;
    }

    public static PendingIntent getPasswordLockPendingIntent(Context context) {
        Intent notificationIntent = CacheWordHandler.getBlankServiceIntent(context);
        notificationIntent.setAction("info.guardianproject.cacheword.LOCK_CACHEWORD");
        return PendingIntent.getService((Context)context, (int)0, (Intent)notificationIntent, (int)0);
    }

    private void registerBroadcastReceiver() {
        LocalBroadcastManager.getInstance((Context)this.mContext).registerReceiver(this.mCacheWordReceiver, new IntentFilter("info.guardianproject.cacheword.NEW_SECRETS"));
    }

    private void unregisterBroadcastRecevier() {
        LocalBroadcastManager.getInstance((Context)this.mContext).unregisterReceiver(this.mCacheWordReceiver);
    }

    private void checkCacheWordState() {
        int newState = -1;
        if (!this.isCacheWordConnected()) {
            newState = -1;
            Log.d((String)TAG, (String)"checkCacheWordState: not connected");
        } else if (!this.isCacheWordInitialized()) {
            newState = 0;
            Log.d((String)TAG, (String)"checkCacheWordState: STATE_UNINITIALIZED");
        } else if (this.isCacheWordConnected() && this.mCacheWordService.isLocked()) {
            newState = 1;
            Log.d((String)TAG, (String)("checkCacheWordState: STATE_LOCKED, but isCacheWordConnected()==" + this.isCacheWordConnected()));
        } else {
            newState = 2;
            Log.d((String)TAG, (String)"checkCacheWordState: STATE_UNLOCKED");
        }
        if (newState == 0) {
            this.mSubscriber.onCacheWordUninitialized();
        } else if (newState == 1) {
            this.mSubscriber.onCacheWordLocked();
        } else if (newState == 2) {
            this.mSubscriber.onCacheWordOpened();
        } else {
            Log.e((String)TAG, (String)"Unknown CacheWord state entered!");
        }
    }

    private boolean isCacheWordConnected() {
        return this.mCacheWordService != null;
    }

    private boolean isCacheWordInitialized() {
        return SecretsManager.isInitialized(this.mContext);
    }

    public void deinitialize() {
        SecretsManager.setInitialized(this.mContext, false);
    }

    private boolean isPrepared() {
        return this.isCacheWordConnected() && this.isCacheWordInitialized();
    }

    static enum BindState {
        BIND_NULL,
        BIND_REQUESTED,
        BIND_COMPLETED;

    }

    static enum ServiceConnectionState {
        CONNECTION_NULL,
        CONNECTION_INPROGRESS,
        CONNECTION_CANCELED,
        CONNECTION_ACTIVE;

    }
}

