/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.cacheword;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.SystemClock;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import info.guardianproject.cacheword.CacheWordHandler;
import info.guardianproject.cacheword.ICacheWordBinder;
import info.guardianproject.cacheword.ICachedSecrets;
import info.guardianproject.cacheword.SecretsManager;

public class CacheWordService
extends Service {
    private static final String TAG = "CacheWordService";
    private final IBinder mBinder = new CacheWordBinder();
    private ICachedSecrets mSecrets = null;
    private Notification mNotification;
    private PendingIntent mTimeoutIntent;
    private int mTimeout = 300;
    private Intent mBroadcastIntent = new Intent("info.guardianproject.cacheword.NEW_SECRETS");
    private int mSubscriberCount = 0;
    private boolean mIsForegrounded = false;

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null) {
            Log.d((String)TAG, (String)"onStart: null intent");
            return 2;
        }
        String action = intent.getAction();
        if (action == null) {
            Log.d((String)TAG, (String)"onStart: null action");
            return 2;
        }
        Log.d((String)TAG, (String)("onStart: with intent " + action));
        if (action.equals("info.guardianproject.cacheword.LOCK_CACHEWORD")) {
            Log.d((String)TAG, (String)"onStart: LOCK COMMAND received..locking");
            this.lock();
        }
        return 2;
    }

    public void onCreate() {
        Log.d((String)TAG, (String)"onCreate");
        super.onCreate();
    }

    public void onTaskRemoved(Intent rootIntent) {
        Log.d((String)TAG, (String)"onTaskRemoved()");
        if (!this.mIsForegrounded) {
            NotificationManager nm = (NotificationManager)this.getSystemService("notification");
            nm.cancel(13218);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mSecrets != null) {
            Log.d((String)TAG, (String)"onDestroy() killed secrets");
            this.mSecrets.destroy();
            this.mSecrets = null;
        } else {
            Log.d((String)TAG, (String)"onDestroy() secrets already null");
        }
    }

    public boolean onUnbind(Intent intent) {
        this.resetTimeout();
        return super.onUnbind(intent);
    }

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public synchronized ICachedSecrets getCachedSecrets() {
        return this.mSecrets;
    }

    public synchronized void setCachedSecrets(ICachedSecrets secrets) {
        Log.d((String)TAG, (String)"setCachedSecrets()");
        this.mSecrets = secrets;
        this.handleNewSecrets(true);
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public void setTimeout(int timeout) {
        this.mTimeout = timeout;
        this.resetTimeout();
    }

    public synchronized boolean isLocked() {
        return this.mSecrets == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        Log.d((String)TAG, (String)"lock");
        CacheWordService cacheWordService = this;
        synchronized (cacheWordService) {
            if (this.mSecrets != null) {
                this.mSecrets.destroy();
                this.mSecrets = null;
            }
        }
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(this.mBroadcastIntent);
        if (this.mIsForegrounded) {
            this.stopForeground(true);
            this.mIsForegrounded = false;
        }
        this.stopSelf();
    }

    public synchronized void attachSubscriber() {
        ++this.mSubscriberCount;
        Log.d((String)TAG, (String)("attachSubscriber(): " + this.mSubscriberCount));
        this.resetTimeout();
    }

    public synchronized void detachSubscriber() {
        --this.mSubscriberCount;
        Log.d((String)TAG, (String)("detachSubscriber(): " + this.mSubscriberCount));
        this.resetTimeout();
    }

    private void handleNewSecrets(boolean notify) {
        if (!SecretsManager.isInitialized((Context)this)) {
            return;
        }
        if (this.mNotification != null) {
            this.stopForeground(true);
            this.startForeground(81231, this.mNotification);
            this.mIsForegrounded = true;
        } else if (this.mIsForegrounded) {
            this.stopForeground(true);
            this.mIsForegrounded = false;
        }
        this.resetTimeout();
        if (notify) {
            LocalBroadcastManager.getInstance((Context)this).sendBroadcast(this.mBroadcastIntent);
        }
    }

    private void resetTimeout() {
        if (this.mTimeout < 0) {
            this.mTimeout = 300;
        }
        boolean timeoutEnabled = this.mTimeout > 0;
        Log.d((String)TAG, (String)("timeout enabled: " + timeoutEnabled + ", seconds=" + this.mTimeout));
        Log.d((String)TAG, (String)("mSubscriberCount: " + this.mSubscriberCount));
        if (timeoutEnabled && this.mSubscriberCount == 0) {
            this.startTimeout(this.mTimeout);
        } else {
            Log.d((String)TAG, (String)"disabled timeout alarm");
            AlarmManager alarmManager = (AlarmManager)this.getSystemService("alarm");
            alarmManager.cancel(this.mTimeoutIntent);
        }
    }

    private void startTimeout(long seconds) {
        if (seconds <= 0L) {
            Log.d((String)TAG, (String)"immediate timeout");
            this.lock();
            return;
        }
        Log.d((String)TAG, (String)("starting timeout: " + seconds));
        if (this.mTimeoutIntent == null) {
            this.mTimeoutIntent = CacheWordHandler.getPasswordLockPendingIntent((Context)this);
        }
        AlarmManager alarmManager = (AlarmManager)this.getSystemService("alarm");
        alarmManager.set(3, SystemClock.elapsedRealtime() + seconds * 1000L, this.mTimeoutIntent);
    }

    public void setNotification(Notification notification) {
        this.mNotification = notification;
    }

    public class CacheWordBinder
    extends Binder
    implements ICacheWordBinder {
        @Override
        public CacheWordService getService() {
            Log.d((String)"CacheWordBinder", (String)"giving service");
            return CacheWordService.this;
        }
    }
}

