/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.cacheword;

import java.nio.ByteBuffer;

public class SerializedSecretsV0 {
    public int version;
    public byte[] salt;
    public byte[] iv;
    public byte[] ciphertext;
    public byte[] serialized;

    public SerializedSecretsV0(int version, byte[] salt, byte[] iv, byte[] ciphertext) {
        this.version = version;
        this.salt = salt;
        this.iv = iv;
        this.ciphertext = ciphertext;
    }

    public SerializedSecretsV0(byte[] serialized) {
        this.serialized = serialized;
    }

    public void parse() {
        this.salt = new byte[16];
        this.iv = new byte[12];
        this.ciphertext = new byte[this.serialized.length - 32];
        ByteBuffer bb = ByteBuffer.wrap(this.serialized);
        this.version = bb.getInt();
        bb.get(this.salt);
        bb.get(this.iv);
        bb.get(this.ciphertext);
    }

    public byte[] concatenate() {
        this.serialized = new byte[32 + this.ciphertext.length];
        ByteBuffer bb = ByteBuffer.wrap(this.serialized);
        bb.putInt(this.version);
        bb.put(this.salt);
        bb.put(this.iv);
        bb.put(this.ciphertext);
        this.serialized = bb.array();
        return this.serialized;
    }
}

