/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtcrime.ssl.pinning;

import android.util.Log;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.thoughtcrime.ssl.pinning.CertificateChainCleaner;
import org.thoughtcrime.ssl.pinning.SystemKeyStore;

public class PinningTrustManager
implements X509TrustManager {
    private final TrustManager[] systemTrustManagers;
    private final SystemKeyStore systemKeyStore;
    private final long enforceUntilTimestampMillis;
    private final List<byte[]> pins = new LinkedList<byte[]>();
    private final Set<X509Certificate> cache = Collections.synchronizedSet(new HashSet());

    public PinningTrustManager(SystemKeyStore keyStore, String[] pins, long enforceUntilTimestampMillis) {
        this.systemTrustManagers = this.initializeSystemTrustManagers(keyStore);
        this.systemKeyStore = keyStore;
        this.enforceUntilTimestampMillis = enforceUntilTimestampMillis;
        for (String pin : pins) {
            this.pins.add(this.hexStringToByteArray(pin));
        }
    }

    private TrustManager[] initializeSystemTrustManagers(SystemKeyStore keyStore) {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
            tmf.init(keyStore.trustStore);
            return tmf.getTrustManagers();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new AssertionError((Object)nsae);
        }
        catch (KeyStoreException e) {
            throw new AssertionError((Object)e);
        }
    }

    private boolean isValidPin(X509Certificate certificate) throws CertificateException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            byte[] spki = certificate.getPublicKey().getEncoded();
            byte[] pin = digest.digest(spki);
            for (byte[] validPin : this.pins) {
                if (!Arrays.equals(validPin, pin)) continue;
                return true;
            }
            return false;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CertificateException(nsae);
        }
    }

    private void checkSystemTrust(X509Certificate[] chain, String authType) throws CertificateException {
        for (TrustManager systemTrustManager : this.systemTrustManagers) {
            ((X509TrustManager)systemTrustManager).checkServerTrusted(chain, authType);
        }
    }

    private void checkPinTrust(X509Certificate[] chain) throws CertificateException {
        X509Certificate[] cleanChain;
        if (this.enforceUntilTimestampMillis != 0L && System.currentTimeMillis() > this.enforceUntilTimestampMillis) {
            Log.w((String)"PinningTrustManager", (String)"Certificate pins are stale, falling back to system trust.");
            return;
        }
        for (X509Certificate certificate : cleanChain = CertificateChainCleaner.getCleanChain(chain, this.systemKeyStore)) {
            if (!this.isValidPin(certificate)) continue;
            return;
        }
        throw new CertificateException("No valid pins found in chain!");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        throw new CertificateException("Client certificates not supported!");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.cache.contains(chain[0])) {
            return;
        }
        this.checkSystemTrust(chain, authType);
        this.checkPinTrust(chain);
        this.cache.add(chain[0]);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }

    private byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public void clearCache() {
        this.cache.clear();
    }
}

