/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtcrime.ssl.pinning;

import android.content.Context;
import android.content.res.Resources;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import org.thoughtcrime.ssl.pinning.R;

public class SystemKeyStore {
    private static final int CACERTS_FILE_SIZE = 143360;
    private static SystemKeyStore instance;
    private final HashMap<Principal, X509Certificate> trustRoots;
    final KeyStore trustStore;

    public static synchronized SystemKeyStore getInstance(Context context) {
        if (instance == null) {
            instance = new SystemKeyStore(context);
        }
        return instance;
    }

    private SystemKeyStore(Context context) {
        KeyStore trustStore = this.getTrustStore(context);
        this.trustRoots = this.initializeTrustedRoots(trustStore);
        this.trustStore = trustStore;
    }

    public boolean isTrustRoot(X509Certificate certificate) {
        X509Certificate trustRoot = this.trustRoots.get(certificate.getSubjectX500Principal());
        return trustRoot != null && trustRoot.getPublicKey().equals(certificate.getPublicKey());
    }

    public X509Certificate getTrustRootFor(X509Certificate certificate) {
        X509Certificate trustRoot = this.trustRoots.get(certificate.getIssuerX500Principal());
        if (trustRoot == null) {
            return null;
        }
        if (trustRoot.getSubjectX500Principal().equals(certificate.getSubjectX500Principal())) {
            return null;
        }
        try {
            certificate.verify(trustRoot.getPublicKey());
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        return trustRoot;
    }

    private HashMap<Principal, X509Certificate> initializeTrustedRoots(KeyStore trustStore) {
        try {
            HashMap<Principal, X509Certificate> trusted = new HashMap<Principal, X509Certificate>();
            Enumeration<String> aliases = trustStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate cert = (X509Certificate)trustStore.getCertificate(alias);
                if (cert == null) continue;
                trusted.put(cert.getSubjectX500Principal(), cert);
            }
            return trusted;
        }
        catch (KeyStoreException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore getTrustStore(Context context) {
        try {
            KeyStore trustStore = KeyStore.getInstance("BKS");
            BufferedInputStream bin = new BufferedInputStream(context.getResources().openRawResource(R.raw.cacerts), 143360);
            try {
                trustStore.load(bin, "changeit".toCharArray());
            }
            finally {
                try {
                    bin.close();
                }
                catch (IOException ioe) {
                    Log.w((String)"SystemKeyStore", (Throwable)ioe);
                }
            }
            return trustStore;
        }
        catch (KeyStoreException kse) {
            throw new AssertionError((Object)kse);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (CertificateException e) {
            throw new AssertionError((Object)e);
        }
        catch (Resources.NotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

