/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.emoji;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.text.Spannable;
import android.text.style.ImageSpan;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import info.guardianproject.emoji.Emoji;
import info.guardianproject.emoji.EmojiGroup;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmojiManager {
    private static EmojiManager mInstance = null;
    private Map<Pattern, Emoji> emoticons = new HashMap<Pattern, Emoji>();
    private Map<String, EmojiGroup> categories = new HashMap<String, EmojiGroup>();
    private Context mContext;
    private static final String PLUGIN_CONSTANT = "info.guardianproject.emoji.STICKER_PACK";

    private EmojiManager(Context context) {
        this.mContext = context;
    }

    public void addJsonPlugins() throws IOException, JsonSyntaxException {
        PackageManager packageManager = this.mContext.getPackageManager();
        Intent stickerIntent = new Intent(PLUGIN_CONSTANT);
        List stickerPack = packageManager.queryIntentActivities(stickerIntent, 0);
        for (ResolveInfo ri : stickerPack) {
            try {
                String[] files;
                Resources res = packageManager.getResourcesForApplication(ri.activityInfo.applicationInfo);
                for (String file : files = res.getAssets().list("")) {
                    if (!file.endsWith(".json")) continue;
                    this.addJsonDefinitions(file, file.substring(0, file.length() - 5), "png", res);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)"emoji", (String)"unable to find application for emoji plugin");
            }
        }
    }

    public void addJsonDefinitions(String assetPathJson, String basePath, String fileExt) throws IOException, JsonSyntaxException {
        this.addJsonDefinitions(assetPathJson, basePath, fileExt, this.mContext.getResources());
    }

    public void addJsonDefinitions(String assetPathJson, String basePath, String fileExt, Resources res) throws IOException, JsonSyntaxException {
        Gson gson = new Gson();
        InputStreamReader reader = new InputStreamReader(res.getAssets().open(assetPathJson));
        Type collectionType = new TypeToken<ArrayList<Emoji>>(){}.getType();
        Collection emojis = (Collection)gson.fromJson((Reader)reader, collectionType);
        for (Emoji emoji : emojis) {
            emoji.assetPath = basePath + '/' + emoji.name + '.' + fileExt;
            emoji.res = res;
            try {
                res.getAssets().open(emoji.assetPath);
                this.addPattern(':' + emoji.name + ':', emoji);
                if (emoji.moji != null) {
                    this.addPattern(emoji.moji, emoji);
                }
                if (emoji.emoticon != null) {
                    this.addPattern(emoji.emoticon, emoji);
                }
                if (emoji.category == null) continue;
                this.addEmojiToCategory(emoji.category, emoji);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
    }

    public Collection<EmojiGroup> getEmojiGroups() {
        return this.categories.values();
    }

    public String getAssetPath(Emoji emoji) {
        return emoji.name;
    }

    public synchronized void addEmojiToCategory(String category, Emoji emoji) {
        EmojiGroup emojiGroup = this.categories.get(category);
        if (emojiGroup == null) {
            emojiGroup = new EmojiGroup();
            emojiGroup.category = category;
            emojiGroup.emojis = new ArrayList();
        }
        emojiGroup.emojis.add(emoji);
        this.categories.put(category, emojiGroup);
    }

    public static synchronized EmojiManager getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new EmojiManager(context);
        }
        return mInstance;
    }

    private void addPattern(String pattern, Emoji resource) {
        this.emoticons.put(Pattern.compile(pattern, 16), resource);
    }

    private void addPattern(char charPattern, Emoji resource) {
        this.emoticons.put(Pattern.compile(charPattern + "", 64), resource);
    }

    public boolean addEmoji(Context context, Spannable spannable) throws IOException {
        boolean hasChanges = false;
        for (Map.Entry<Pattern, Emoji> entry : this.emoticons.entrySet()) {
            Matcher matcher = entry.getKey().matcher((CharSequence)spannable);
            while (matcher.find()) {
                boolean set = true;
                for (ImageSpan span : (ImageSpan[])spannable.getSpans(matcher.start(), matcher.end(), ImageSpan.class)) {
                    if (spannable.getSpanStart((Object)span) < matcher.start() || spannable.getSpanEnd((Object)span) > matcher.end()) {
                        set = false;
                        break;
                    }
                    spannable.removeSpan((Object)span);
                }
                if (!set) continue;
                hasChanges = true;
                Emoji emoji = entry.getValue();
                spannable.setSpan((Object)new ImageSpan(context, BitmapFactory.decodeStream((InputStream)emoji.res.getAssets().open(emoji.assetPath))), matcher.start(), matcher.end(), 33);
            }
        }
        return hasChanges;
    }
}

