/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.emoji;

import android.content.Context;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.Spannable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ListAdapter;
import info.guardianproject.emoji.Emoji;
import info.guardianproject.emoji.EmojiGridAdapter;
import info.guardianproject.emoji.EmojiGroup;
import info.guardianproject.emoji.EmojiManager;
import info.guardianproject.emoji.R;
import java.io.IOException;
import java.util.List;

public class EmojiPagerAdapter
extends PagerAdapter {
    EmojiGridAdapter[] gias;
    List<EmojiGroup> mEmojiGroups;
    Context mContext;
    EditText mEditable;

    public EmojiPagerAdapter(Context context, EditText editable, List<EmojiGroup> emojiGroups) {
        this.mContext = context;
        this.mEditable = editable;
        this.mEmojiGroups = emojiGroups;
        this.gias = new EmojiGridAdapter[this.mEmojiGroups.size()];
    }

    public Object instantiateItem(View collection, int position) {
        this.gias[position] = new EmojiGridAdapter(this.mContext, this.mEmojiGroups.get((int)position).emojis);
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        GridView imagegrid = (GridView)inflater.inflate(R.layout.emojigrid, null);
        imagegrid.setAdapter((ListAdapter)this.gias[position]);
        imagegrid.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
                GridView gv = (GridView)arg0;
                Emoji t = (Emoji)((EmojiGridAdapter)gv.getAdapter()).getItem(arg2);
                if (t.emoticon != null) {
                    EmojiPagerAdapter.this.mEditable.append((CharSequence)t.emoticon);
                } else if (t.moji != null) {
                    EmojiPagerAdapter.this.mEditable.append((CharSequence)t.moji);
                } else if (t.unicode == null) {
                    EmojiPagerAdapter.this.mEditable.append((CharSequence)(':' + t.name + ':'));
                }
                if (EmojiPagerAdapter.this.mEditable != null) {
                    try {
                        EmojiManager.getInstance(EmojiPagerAdapter.this.mContext.getApplicationContext()).addEmoji(EmojiPagerAdapter.this.mContext, (Spannable)EmojiPagerAdapter.this.mEditable.getEditableText());
                    }
                    catch (IOException e) {
                        Log.e((String)"Emoji", (String)"error adding simle", (Throwable)e);
                    }
                }
            }
        });
        ((ViewPager)collection).addView((View)imagegrid);
        return imagegrid;
    }

    public int getCount() {
        return this.mEmojiGroups.size();
    }

    public boolean isViewFromObject(View arg0, Object arg1) {
        return arg0 == arg1;
    }

    public void destroyItem(ViewGroup collection, int position, Object arg2) {
        ((ViewPager)collection).removeView((View)((ViewGroup)arg2));
    }

    public Parcelable saveState() {
        return null;
    }

    public void startUpdate(ViewGroup collection) {
    }

    public void finishUpdate(ViewGroup collection) {
    }

    public CharSequence getPageTitle(int position) {
        return this.mEmojiGroups.get((int)position).category;
    }
}

