/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtcrime.ssl.pinning.util;

import android.content.Context;
import java.io.IOException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.thoughtcrime.ssl.pinning.PinningSSLSocketFactory;
import org.thoughtcrime.ssl.pinning.PinningTrustManager;
import org.thoughtcrime.ssl.pinning.SystemKeyStore;

public class PinningHelper {
    public static HttpClient getPinnedHttpClient(Context context, String[] pins) {
        try {
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            schemeRegistry.register(new Scheme("https", (SocketFactory)new PinningSSLSocketFactory(context, pins, 0L), 443));
            BasicHttpParams httpParams = new BasicHttpParams();
            ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager((HttpParams)httpParams, schemeRegistry);
            return new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)httpParams);
        }
        catch (UnrecoverableKeyException e) {
            throw new AssertionError((Object)e);
        }
        catch (KeyManagementException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (KeyStoreException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static HttpsURLConnection getPinnedHttpsURLConnection(Context context, String[] pins, URL url) throws IOException {
        try {
            if (!url.getProtocol().equals("https")) {
                throw new IllegalArgumentException("Attempt to construct pinned non-https connection!");
            }
            TrustManager[] trustManagers = new TrustManager[]{new PinningTrustManager(SystemKeyStore.getInstance(context), pins, 0L)};
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagers, null);
            HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
            urlConnection.setSSLSocketFactory(sslContext.getSocketFactory());
            return urlConnection;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new AssertionError((Object)nsae);
        }
        catch (KeyManagementException e) {
            throw new AssertionError((Object)e);
        }
    }
}

