/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.cacheword;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import info.guardianproject.cacheword.ICachedSecrets;
import info.guardianproject.cacheword.PassphraseSecretsImpl;
import info.guardianproject.cacheword.SecretsManager;
import info.guardianproject.cacheword.SerializedSecretsLoader;
import info.guardianproject.cacheword.SerializedSecretsV1;
import info.guardianproject.cacheword.Wiper;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class PassphraseSecrets
implements ICachedSecrets {
    private static final String TAG = "PassphraseSecrets";
    private final SecretKey mSecretKey;

    private PassphraseSecrets(byte[] key) throws GeneralSecurityException {
        this.mSecretKey = new SecretKeySpec(key, "AES");
    }

    private PassphraseSecrets(SecretKey key) throws GeneralSecurityException {
        this.mSecretKey = key;
    }

    public SecretKey getSecretKey() {
        return this.mSecretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PassphraseSecrets initializeSecrets(Context ctx, char[] x_passphrase) {
        PassphraseSecretsImpl crypto = new PassphraseSecretsImpl();
        try {
            SecretKeySpec secretKey = (SecretKeySpec)crypto.generateSecretKey();
            boolean saved = PassphraseSecrets.encryptAndSave(ctx, x_passphrase, secretKey.getEncoded());
            SecretsManager.setInitialized(ctx, saved);
            if (saved) {
                PassphraseSecrets passphraseSecrets = new PassphraseSecrets(secretKey);
                return passphraseSecrets;
            }
            PassphraseSecrets passphraseSecrets = null;
            return passphraseSecrets;
        }
        catch (GeneralSecurityException e) {
            Log.e((String)TAG, (String)("initializeSecrets failed: " + e.getClass().getName() + " : " + e.getMessage()));
            PassphraseSecrets passphraseSecrets = null;
            return passphraseSecrets;
        }
        finally {
            Wiper.wipe(x_passphrase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PassphraseSecrets fetchSecrets(Context ctx, char[] x_passphrase) throws GeneralSecurityException {
        PassphraseSecrets passphraseSecrets;
        byte[] preparedSecret = SecretsManager.getBytes(ctx, "encrypted_secrets");
        SerializedSecretsV1 ss = new SerializedSecretsLoader().loadSecrets(preparedSecret);
        byte[] x_rawSecretKey = null;
        try {
            PassphraseSecretsImpl crypto = new PassphraseSecretsImpl();
            x_rawSecretKey = crypto.decryptWithPassphrase(x_passphrase, ss);
            PassphraseSecrets ps = new PassphraseSecrets(x_rawSecretKey);
            if (ss.pbkdf_iter_count < 1024 && (ps = PassphraseSecrets.changePassphrase(ctx, ps, x_passphrase)) == null) {
                throw new GeneralSecurityException("Upgrading iteration count failed during save");
            }
            passphraseSecrets = ps;
        }
        catch (Throwable throwable) {
            Wiper.wipe(x_passphrase);
            Wiper.wipe(x_rawSecretKey);
            throw throwable;
        }
        Wiper.wipe(x_passphrase);
        Wiper.wipe(x_rawSecretKey);
        return passphraseSecrets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PassphraseSecrets changePassphrase(Context ctx, PassphraseSecrets current_secrets, char[] x_new_passphrase) {
        byte[] x_rawSecretKey = null;
        try {
            x_rawSecretKey = current_secrets.getSecretKey().getEncoded();
            boolean saved = PassphraseSecrets.encryptAndSave(ctx, x_new_passphrase, x_rawSecretKey);
            if (saved) {
                PassphraseSecrets passphraseSecrets = current_secrets;
                return passphraseSecrets;
            }
            PassphraseSecrets passphraseSecrets = null;
            return passphraseSecrets;
        }
        catch (GeneralSecurityException e) {
            Log.e((String)TAG, (String)("changePassphrase failed: " + e.getClass().getName() + " : " + e.getMessage()));
            PassphraseSecrets passphraseSecrets = null;
            return passphraseSecrets;
        }
        finally {
            Wiper.wipe(x_new_passphrase);
            Wiper.wipe(x_rawSecretKey);
        }
    }

    private static boolean encryptAndSave(Context ctx, char[] x_passphrase, byte[] x_plaintext) throws GeneralSecurityException {
        PassphraseSecretsImpl crypto = new PassphraseSecretsImpl();
        int pbkdf2_iter_count = PassphraseSecrets.calibrateKDF(ctx);
        SerializedSecretsV1 ss = crypto.encryptWithPassphrase(ctx, x_passphrase, x_plaintext, pbkdf2_iter_count);
        byte[] preparedSecret = ss.getBytes();
        boolean saved = SecretsManager.saveBytes(ctx, "encrypted_secrets", preparedSecret);
        return saved;
    }

    private static int calibrateKDF(Context ctx) {
        int iterations = 4096;
        if (Build.CPU_ABI.equals("x86")) {
            iterations = 40 * PassphraseSecrets.getBogoMips();
        } else if (Build.CPU_ABI.equals("armeabi-v7a") || Build.CPU_ABI2.equals("armeabi-v7a")) {
            iterations = 20 * PassphraseSecrets.getBogoMips();
        } else if (Build.CPU_ABI.equals("armeabi") || Build.CPU_ABI2.equals("armeabi")) {
            iterations = 10 * PassphraseSecrets.getBogoMips();
        }
        int r = Math.max(1024, iterations);
        for (int power = 1; power < r; power *= 2) {
        }
        Log.d((String)TAG, (String)("calibrateKDF() selected: " + iterations + "  using: " + r));
        return r;
    }

    private static int getBogoMips() {
        try {
            FileReader br = new FileReader("/proc/cpuinfo");
            char[] buffer = new char[8192];
            br.read(buffer);
            br.close();
            String cpuinfo = new String(buffer);
            Pattern p = Pattern.compile(".*[Bb][Oo][Gg][Oo][Mm][Ii][Pp][Ss]\\s*:\\s*([0-9.]+).*");
            Matcher matcher = p.matcher(cpuinfo);
            if (matcher.find()) {
                return (int)Float.parseFloat(matcher.group(1));
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 500;
    }

    @Override
    public void destroy() {
        Log.d((String)TAG, (String)"destroy()");
        Wiper.wipe((SecretKeySpec)this.mSecretKey);
    }
}

