/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.cacheword;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import info.guardianproject.cacheword.PRNGFixes;

public class SecretsManager {
    private static boolean prngFixesApplied = false;

    public static boolean isInitialized(Context ctx) {
        SecretsManager.possiblyApplyPRNGFixes(ctx);
        return SecretsManager.getPrefs(ctx).getBoolean("initialized", false);
    }

    public static boolean saveBytes(Context ctx, String key, byte[] value) {
        String encoded = Base64.encodeToString((byte[])value, (int)0);
        SharedPreferences.Editor e = SecretsManager.getPrefs(ctx).edit();
        e.putString(key, encoded);
        return e.commit();
    }

    public static byte[] getBytes(Context ctx, String key) {
        String encoded = SecretsManager.getPrefs(ctx).getString(key, null);
        if (encoded == null) {
            return null;
        }
        return Base64.decode((String)encoded, (int)0);
    }

    public static boolean setInitialized(Context ctx, boolean initialized) {
        SharedPreferences.Editor e = SecretsManager.getPrefs(ctx).edit();
        e.putBoolean("initialized", initialized);
        return e.commit();
    }

    private static void possiblyApplyPRNGFixes(Context ctx) {
        if (!prngFixesApplied) {
            PRNGFixes.apply();
            prngFixesApplied = true;
        }
    }

    private static SharedPreferences getPrefs(Context ctx) {
        return ctx.getSharedPreferences("info.guardianproject.cacheword.prefs", 0);
    }
}

