/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.cacheword;

import java.nio.ByteBuffer;

public class SerializedSecretsV1 {
    public int version;
    public int pbkdf_iter_count;
    public byte[] salt;
    public byte[] iv;
    public byte[] ciphertext;
    public byte[] serialized;

    public SerializedSecretsV1(int version, int iterations, byte[] salt, byte[] iv, byte[] ciphertext) {
        this.version = version;
        this.pbkdf_iter_count = iterations;
        this.salt = salt;
        this.iv = iv;
        this.ciphertext = ciphertext;
    }

    public SerializedSecretsV1(byte[] serialized) {
        this.serialized = serialized;
        this.salt = new byte[16];
        this.iv = new byte[12];
        this.ciphertext = new byte[serialized.length - SerializedSecretsV1.constants_length()];
        ByteBuffer bb = ByteBuffer.wrap(serialized);
        this.version = bb.getInt();
        this.pbkdf_iter_count = bb.getInt();
        bb.get(this.salt);
        bb.get(this.iv);
        bb.get(this.ciphertext);
    }

    public byte[] getBytes() {
        this.serialized = new byte[SerializedSecretsV1.constants_length() + this.ciphertext.length];
        ByteBuffer bb = ByteBuffer.wrap(this.serialized);
        bb.putInt(this.version);
        bb.putInt(this.pbkdf_iter_count);
        bb.put(this.salt);
        bb.put(this.iv);
        bb.put(this.ciphertext);
        this.serialized = bb.array();
        return this.serialized;
    }

    public static int constants_length() {
        int bytes = 36;
        return bytes;
    }
}

