/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.cacheword;

import android.annotation.SuppressLint;
import android.content.Context;
import info.guardianproject.cacheword.SerializedSecretsV1;
import info.guardianproject.cacheword.Wiper;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class PassphraseSecretsImpl {
    private static final String TAG = "PassphraseSecretsImpl";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializedSecretsV1 encryptWithPassphrase(Context ctx, char[] x_passphrase, byte[] x_plaintext, int pbkdf2_iter_count) throws GeneralSecurityException {
        SerializedSecretsV1 serializedSecretsV1;
        SecretKeySpec x_passphraseKey = null;
        try {
            SerializedSecretsV1 ss;
            byte[] salt = this.generateSalt(16);
            byte[] iv = this.generateIv(12);
            x_passphraseKey = this.hashPassphrase(x_passphrase, salt, pbkdf2_iter_count);
            byte[] encryptedSecretKey = this.encryptSecretKey(x_passphraseKey, iv, x_plaintext);
            serializedSecretsV1 = ss = new SerializedSecretsV1(1, pbkdf2_iter_count, salt, iv, encryptedSecretKey);
        }
        catch (Throwable throwable) {
            Wiper.wipe(x_passphraseKey);
            throw throwable;
        }
        Wiper.wipe(x_passphraseKey);
        return serializedSecretsV1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decryptWithPassphrase(char[] x_passphrase, SerializedSecretsV1 ss) throws GeneralSecurityException {
        byte[] byArray;
        byte[] x_plaintext = null;
        SecretKeySpec x_passphraseKey = null;
        try {
            byte[] salt = ss.salt;
            byte[] iv = ss.iv;
            byte[] ciphertext = ss.ciphertext;
            int iterations = ss.pbkdf_iter_count;
            x_passphraseKey = this.hashPassphrase(x_passphrase, salt, iterations);
            byArray = x_plaintext = this.decryptWithKey(x_passphraseKey, iv, ciphertext);
        }
        catch (Throwable throwable) {
            Wiper.wipe(x_passphraseKey);
            throw throwable;
        }
        Wiper.wipe(x_passphraseKey);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecretKeySpec hashPassphrase(char[] x_password, byte[] salt, int pbkdf2_iter_count) throws GeneralSecurityException {
        SecretKeySpec secretKeySpec;
        PBEKeySpec x_spec = null;
        try {
            x_spec = new PBEKeySpec(x_password, salt, pbkdf2_iter_count, 128);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            secretKeySpec = new SecretKeySpec(factory.generateSecret(x_spec).getEncoded(), "AES");
        }
        catch (Throwable throwable) {
            Wiper.wipe(x_spec);
            throw throwable;
        }
        Wiper.wipe(x_spec);
        return secretKeySpec;
    }

    public byte[] decryptWithKey(SecretKey x_passphraseKey, byte[] iv, byte[] ciphertext) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)x_passphraseKey, new IvParameterSpec(iv));
        return cipher.doFinal(ciphertext);
    }

    public byte[] encryptSecretKey(SecretKey x_passphraseKey, byte[] iv, byte[] data) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(1, (Key)x_passphraseKey, new IvParameterSpec(iv));
        return cipher.doFinal(data);
    }

    @SuppressLint(value={"TrulyRandom"})
    public byte[] generateIv(int length) throws NoSuchAlgorithmException {
        byte[] iv = new byte[length];
        SecureRandom.getInstance("SHA1PRNG").nextBytes(iv);
        return iv;
    }

    public byte[] generateSalt(int length) throws NoSuchAlgorithmException {
        byte[] salt = new byte[length];
        SecureRandom.getInstance("SHA1PRNG").nextBytes(salt);
        return salt;
    }

    public SecretKey generateSecretKey() {
        try {
            KeyGenerator generator = KeyGenerator.getInstance("AES");
            generator.init(256);
            return generator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }
}

