/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.cacheword;

import info.guardianproject.cacheword.SerializedSecretsV0;
import info.guardianproject.cacheword.SerializedSecretsV1;
import java.nio.ByteBuffer;

public class SerializedSecretsLoader {
    public SerializedSecretsV1 loadSecrets(byte[] secrets) {
        try {
            int version = this.getVersion(secrets);
            switch (version) {
                case 0: {
                    return this.migrateV0toV1(new SerializedSecretsV0(secrets));
                }
                case 1: {
                    return new SerializedSecretsV1(secrets);
                }
            }
            return null;
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    public int getVersion(byte[] serialized) throws UnsupportedOperationException {
        ByteBuffer bb = ByteBuffer.wrap(serialized);
        int version = bb.getInt();
        if (version < 0 || version > 1) {
            throw new UnsupportedOperationException("Can't load version: " + version);
        }
        return version;
    }

    private SerializedSecretsV1 migrateV0toV1(SerializedSecretsV0 ss0) {
        int old_harcoded_iter_count = 100;
        ss0.parse();
        SerializedSecretsV1 ss1 = new SerializedSecretsV1(1, 100, ss0.salt, ss0.iv, ss0.ciphertext);
        return ss1;
    }
}

