/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.TextView;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import net.hockeyapp.android.FeedbackActivityInterface;
import net.hockeyapp.android.adapters.MessagesAdapter;
import net.hockeyapp.android.objects.ErrorObject;
import net.hockeyapp.android.objects.FeedbackMessage;
import net.hockeyapp.android.objects.FeedbackResponse;
import net.hockeyapp.android.tasks.ParseFeedbackTask;
import net.hockeyapp.android.tasks.SendFeedbackTask;
import net.hockeyapp.android.utils.PrefsUtil;
import net.hockeyapp.android.views.FeedbackView;

public class FeedbackActivity
extends Activity
implements FeedbackActivityInterface,
View.OnClickListener {
    private final int DIALOG_ERROR_ID = 0;
    private Context context;
    private TextView lastUpdatedTextView;
    private EditText nameInput;
    private EditText emailInput;
    private EditText subjectInput;
    private EditText textInput;
    private Button sendFeedbackButton;
    private Button addResponseButton;
    private Button refreshButton;
    private ScrollView feedbackScrollView;
    private LinearLayout wrapperLayoutFeedbackAndMessages;
    private ListView messagesListView;
    private SendFeedbackTask sendFeedbackTask;
    private Handler feedbackHandler;
    private ParseFeedbackTask parseFeedbackTask;
    private Handler parseFeedbackHandler;
    private String url;
    private ErrorObject error;
    private MessagesAdapter messagesAdapter;
    private ArrayList<FeedbackMessage> feedbackMessages;
    private boolean inSendFeedback;
    private String token;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView((View)this.getLayoutView());
        this.setTitle("Feedback");
        this.context = this;
        this.inSendFeedback = false;
        Bundle extras = this.getIntent().getExtras();
        if (extras != null) {
            this.url = extras.getString("url");
        }
        this.initFeedbackHandler();
        this.initParseFeedbackHandler();
        this.configureAppropriateView();
    }

    private void configureAppropriateView() {
        this.token = PrefsUtil.getInstance().getFeedbackTokenFromPrefs((Context)this);
        if (this.token == null) {
            this.configureFeedbackView(false);
        } else {
            this.configureFeedbackView(true);
            this.sendFetchFeedback(this.url, null, null, null, null, this.token, this.feedbackHandler, true);
        }
    }

    private void resetFeedbackView() {
        this.runOnUiThread(new Runnable(){

            public void run() {
                PrefsUtil.getInstance().saveFeedbackTokenToPrefs((Context)FeedbackActivity.this, null);
                FeedbackActivity.this.configureFeedbackView(false);
            }
        });
    }

    private void initFeedbackHandler() {
        this.feedbackHandler = new Handler(){

            public void handleMessage(Message msg) {
                boolean success = false;
                FeedbackActivity.this.error = new ErrorObject();
                if (msg != null && msg.getData() != null) {
                    Bundle bundle = msg.getData();
                    String responseString = bundle.getString("feedback_response");
                    String statusCode = bundle.getString("feedback_status");
                    String requestType = bundle.getString("request_type");
                    if (requestType.equals("send") && (responseString == null || Integer.parseInt(statusCode) != 201)) {
                        FeedbackActivity.this.error.setMessage("Message couldn't be posted. Please check your input values and try again.");
                    } else if (requestType.equals("fetch") && (Integer.parseInt(statusCode) == 404 || Integer.parseInt(statusCode) == 422)) {
                        FeedbackActivity.this.resetFeedbackView();
                        success = true;
                    } else {
                        FeedbackActivity.this.startParseFeedbackTask(responseString);
                        success = true;
                    }
                } else {
                    FeedbackActivity.this.error.setMessage("Message couldn't be posted. Please check your input values and try again.");
                }
                if (!success) {
                    FeedbackActivity.this.runOnUiThread(new Runnable(){

                        public void run() {
                            FeedbackActivity.this.enableDisableSendFeedbackButton(true);
                            FeedbackActivity.this.showDialog(0);
                        }
                    });
                }
            }
        };
    }

    private void initParseFeedbackHandler() {
        this.parseFeedbackHandler = new Handler(){

            public void handleMessage(Message msg) {
                Bundle bundle;
                FeedbackResponse feedbackResponse;
                boolean success = false;
                FeedbackActivity.this.error = new ErrorObject();
                if (msg != null && msg.getData() != null && (feedbackResponse = (FeedbackResponse)(bundle = msg.getData()).getSerializable("parse_feedback_response")) != null) {
                    if (feedbackResponse.getStatus().equalsIgnoreCase("success")) {
                        success = true;
                        if (feedbackResponse.getToken() != null) {
                            PrefsUtil.getInstance().saveFeedbackTokenToPrefs(FeedbackActivity.this.context, feedbackResponse.getToken());
                            FeedbackActivity.this.loadFeedbackMessages(feedbackResponse);
                            FeedbackActivity.this.inSendFeedback = false;
                        }
                    } else {
                        success = false;
                    }
                }
                if (!success) {
                    FeedbackActivity.this.runOnUiThread(new Runnable(){

                        public void run() {
                            FeedbackActivity.this.showDialog(0);
                        }
                    });
                }
                FeedbackActivity.this.enableDisableSendFeedbackButton(true);
            }
        };
    }

    protected void configureFeedbackView(boolean haveToken) {
        this.feedbackScrollView = (ScrollView)this.findViewById(131095);
        this.wrapperLayoutFeedbackAndMessages = (LinearLayout)this.findViewById(131093);
        this.messagesListView = (ListView)this.findViewById(131094);
        if (haveToken) {
            this.wrapperLayoutFeedbackAndMessages.setVisibility(0);
            this.feedbackScrollView.setVisibility(8);
            this.lastUpdatedTextView = (TextView)this.findViewById(8192);
            this.addResponseButton = (Button)this.findViewById(131088);
            this.addResponseButton.setOnClickListener((View.OnClickListener)this);
            this.refreshButton = (Button)this.findViewById(131089);
            this.refreshButton.setOnClickListener((View.OnClickListener)this);
        } else {
            this.wrapperLayoutFeedbackAndMessages.setVisibility(8);
            this.feedbackScrollView.setVisibility(0);
            this.nameInput = (EditText)this.findViewById(8194);
            this.emailInput = (EditText)this.findViewById(8196);
            this.subjectInput = (EditText)this.findViewById(8198);
            this.textInput = (EditText)this.findViewById(8200);
            String nameEmailSubject = PrefsUtil.getInstance().getNameEmailFromPrefs(this.context);
            if (nameEmailSubject != null) {
                String[] nameEmailSubjectArray = nameEmailSubject.split("\\|");
                if (nameEmailSubjectArray != null && nameEmailSubjectArray.length == 3) {
                    this.nameInput.setText((CharSequence)nameEmailSubjectArray[0]);
                    this.emailInput.setText((CharSequence)nameEmailSubjectArray[1]);
                    this.subjectInput.setText((CharSequence)nameEmailSubjectArray[2]);
                }
            } else {
                this.nameInput.setText((CharSequence)"");
                this.emailInput.setText((CharSequence)"");
                this.subjectInput.setText((CharSequence)"");
            }
            this.textInput.setText((CharSequence)"");
            if (PrefsUtil.getInstance().getFeedbackTokenFromPrefs(this.context) != null) {
                this.subjectInput.setVisibility(8);
            } else {
                this.subjectInput.setVisibility(0);
            }
            this.sendFeedbackButton = (Button)this.findViewById(8201);
            this.sendFeedbackButton.setOnClickListener((View.OnClickListener)this);
        }
    }

    public ViewGroup getLayoutView() {
        return new FeedbackView((Context)this);
    }

    private void loadFeedbackMessages(final FeedbackResponse feedbackResponse) {
        this.runOnUiThread(new Runnable(){

            public void run() {
                FeedbackActivity.this.configureFeedbackView(true);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                SimpleDateFormat formatNew = new SimpleDateFormat("d MMM h:mm a");
                Date date = null;
                if (feedbackResponse != null && feedbackResponse.getFeedback() != null && feedbackResponse.getFeedback().getMessages() != null && feedbackResponse.getFeedback().getMessages().size() > 0) {
                    FeedbackActivity.this.feedbackMessages = feedbackResponse.getFeedback().getMessages();
                    Collections.reverse(FeedbackActivity.this.feedbackMessages);
                    try {
                        date = format.parse(((FeedbackMessage)FeedbackActivity.this.feedbackMessages.get(0)).getCreatedAt());
                        FeedbackActivity.this.lastUpdatedTextView.setText((CharSequence)String.format("Last Updated: %s", formatNew.format(date)));
                    }
                    catch (ParseException e1) {
                        e1.printStackTrace();
                    }
                    if (FeedbackActivity.this.messagesAdapter == null) {
                        FeedbackActivity.this.messagesAdapter = new MessagesAdapter(FeedbackActivity.this.context, FeedbackActivity.this.feedbackMessages);
                    } else {
                        FeedbackActivity.this.messagesAdapter.clear();
                        for (FeedbackMessage message : FeedbackActivity.this.feedbackMessages) {
                            FeedbackActivity.this.messagesAdapter.add(message);
                        }
                        FeedbackActivity.this.messagesAdapter.notifyDataSetChanged();
                    }
                    FeedbackActivity.this.messagesListView.setAdapter((ListAdapter)FeedbackActivity.this.messagesAdapter);
                }
            }
        });
    }

    private void sendFeedback() {
        this.enableDisableSendFeedbackButton(false);
        if (this.nameInput.getText().toString().trim().length() <= 0 || this.emailInput.getText().toString().trim().length() <= 0 || this.subjectInput.getText().toString().trim().length() <= 0 || this.textInput.getText().toString().trim().length() <= 0) {
            this.error = new ErrorObject();
            this.error.setMessage("Please provide all details");
            this.showDialog(0);
            this.enableDisableSendFeedbackButton(true);
        } else {
            PrefsUtil.getInstance().saveNameEmailSubjectToPrefs(this.context, this.nameInput.getText().toString(), this.emailInput.getText().toString(), this.subjectInput.getText().toString());
            this.sendFetchFeedback(this.url, this.nameInput.getText().toString(), this.emailInput.getText().toString(), this.subjectInput.getText().toString(), this.textInput.getText().toString(), PrefsUtil.getInstance().getFeedbackTokenFromPrefs(this.context), this.feedbackHandler, false);
        }
    }

    private void sendFetchFeedback(String url, String name, String email, String subject, String text, String token, Handler feedbackHandler, boolean isFetchMessages) {
        this.sendFeedbackTask = new SendFeedbackTask(this.context, url, name, email, subject, text, token, feedbackHandler, isFetchMessages);
        this.sendFeedbackTask.execute(new Void[0]);
    }

    private void startParseFeedbackTask(String feedbackResponseString) {
        this.createParseFeedbackTask(feedbackResponseString);
        this.parseFeedbackTask.execute(new Void[0]);
    }

    private void createParseFeedbackTask(String feedbackResponseString) {
        this.parseFeedbackTask = new ParseFeedbackTask((Context)this, feedbackResponseString, this.parseFeedbackHandler);
    }

    public void enableDisableSendFeedbackButton(boolean isEnable) {
        if (this.sendFeedbackButton != null) {
            this.sendFeedbackButton.setEnabled(isEnable);
        }
    }

    public Object onRetainNonConfigurationInstance() {
        if (this.sendFeedbackTask != null) {
            this.sendFeedbackTask.detach();
        }
        return this.sendFeedbackTask;
    }

    public void onClick(View v) {
        switch (v.getId()) {
            case 8201: {
                this.sendFeedback();
                break;
            }
            case 131088: {
                this.configureFeedbackView(false);
                this.inSendFeedback = true;
                break;
            }
            case 131089: {
                this.sendFetchFeedback(this.url, null, null, null, null, PrefsUtil.getInstance().getFeedbackTokenFromPrefs(this.context), this.feedbackHandler, true);
                break;
            }
        }
    }

    protected Dialog onCreateDialog(int id) {
        switch (id) {
            case 0: {
                return new AlertDialog.Builder((Context)this).setMessage((CharSequence)"An error has occured").setCancelable(false).setTitle((CharSequence)"Error").setIcon(17301543).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id) {
                        FeedbackActivity.this.error = null;
                        dialog.cancel();
                    }
                }).create();
            }
        }
        return null;
    }

    protected void onPrepareDialog(int id, Dialog dialog) {
        switch (id) {
            case 0: {
                AlertDialog messageDialogError = (AlertDialog)dialog;
                if (this.error != null) {
                    messageDialogError.setMessage((CharSequence)this.error.getMessage());
                    break;
                }
                messageDialogError.setMessage((CharSequence)"An error has occured");
            }
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            if (this.inSendFeedback) {
                this.inSendFeedback = false;
                this.configureAppropriateView();
            } else {
                this.finish();
            }
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }
}

