/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.app.Activity;
import android.app.DialogFragment;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.TextView;
import net.hockeyapp.android.UpdateInfoListener;
import net.hockeyapp.android.UpdateManager;
import net.hockeyapp.android.UpdateManagerListener;
import net.hockeyapp.android.listeners.DownloadFileListener;
import net.hockeyapp.android.tasks.DownloadFileTask;
import net.hockeyapp.android.utils.VersionHelper;
import net.hockeyapp.android.views.UpdateView;
import org.json.JSONArray;
import org.json.JSONException;

public class UpdateFragment
extends DialogFragment
implements View.OnClickListener,
UpdateInfoListener {
    private DownloadFileTask downloadTask;
    private JSONArray versionInfo;
    private String urlString;
    private VersionHelper versionHelper;

    public static UpdateFragment newInstance(JSONArray versionInfo, String urlString) {
        Bundle state = new Bundle();
        state.putString("url", urlString);
        state.putString("versionInfo", versionInfo.toString());
        UpdateFragment fragment = new UpdateFragment();
        fragment.setArguments(state);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.urlString = this.getArguments().getString("url");
            this.versionInfo = new JSONArray(this.getArguments().getString("versionInfo"));
        }
        catch (JSONException e) {
            this.dismiss();
            return;
        }
        this.setStyle(1, 16973939);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = this.getLayoutView();
        this.versionHelper = new VersionHelper(this.versionInfo.toString(), this);
        TextView nameLabel = (TextView)view.findViewById(4098);
        nameLabel.setText((CharSequence)this.getAppName());
        TextView versionLabel = (TextView)view.findViewById(4099);
        versionLabel.setText((CharSequence)("Version " + this.versionHelper.getVersionString() + "\n" + this.versionHelper.getFileInfoString()));
        Button updateButton = (Button)view.findViewById(4100);
        updateButton.setOnClickListener((View.OnClickListener)this);
        WebView webView = (WebView)view.findViewById(4101);
        webView.clearCache(true);
        webView.destroyDrawingCache();
        webView.loadDataWithBaseURL("https://sdk.hockeyapp.net/", this.versionHelper.getReleaseNotes(false), "text/html", "utf-8", null);
        return view;
    }

    public void onClick(View view) {
        this.startDownloadTask(this.getActivity());
        this.dismiss();
    }

    private void startDownloadTask(final Activity activity) {
        this.downloadTask = new DownloadFileTask((Context)activity, this.urlString, new DownloadFileListener(){

            public void downloadFailed(DownloadFileTask task, Boolean userWantsRetry) {
                if (userWantsRetry.booleanValue()) {
                    UpdateFragment.this.startDownloadTask(activity);
                }
            }

            public void downloadSuccessful(DownloadFileTask task) {
            }

            public String getStringForResource(int resourceID) {
                UpdateManagerListener listener = UpdateManager.getLastListener();
                if (listener != null) {
                    return listener.getStringForResource(resourceID);
                }
                return null;
            }
        });
        this.downloadTask.execute(new String[0]);
    }

    public int getCurrentVersionCode() {
        int currentVersionCode = -1;
        try {
            currentVersionCode = this.getActivity().getPackageManager().getPackageInfo((String)this.getActivity().getPackageName(), (int)128).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return currentVersionCode;
    }

    public String getAppName() {
        Activity activity = this.getActivity();
        try {
            PackageManager pm = activity.getPackageManager();
            ApplicationInfo applicationInfo = pm.getApplicationInfo(activity.getPackageName(), 0);
            return ((Object)pm.getApplicationLabel(applicationInfo)).toString();
        }
        catch (PackageManager.NameNotFoundException exception) {
            return "";
        }
    }

    public View getLayoutView() {
        return new UpdateView((Context)this.getActivity(), false, true);
    }
}

