/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.AsyncTask;
import android.os.Build;
import java.lang.ref.WeakReference;
import java.util.Date;
import net.hockeyapp.android.ExpiryInfoActivity;
import net.hockeyapp.android.UpdateManagerListener;
import net.hockeyapp.android.tasks.CheckUpdateTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateManager {
    private static CheckUpdateTask updateTask = null;
    private static UpdateManagerListener lastListener = null;

    public static void register(Activity activity, String appIdentifier) {
        UpdateManager.register(activity, appIdentifier, null);
    }

    public static void register(Activity activity, String appIdentifier, UpdateManagerListener listener) {
        UpdateManager.register(activity, "https://sdk.hockeyapp.net/", appIdentifier, listener);
    }

    public static void register(Activity activity, String urlString, String appIdentifier, UpdateManagerListener listener) {
        lastListener = listener;
        WeakReference<Activity> weakActivity = new WeakReference<Activity>(activity);
        if (UpdateManager.fragmentsSupported().booleanValue() && UpdateManager.dialogShown(weakActivity)) {
            return;
        }
        if (!UpdateManager.checkExpiryDate(weakActivity, listener) && !UpdateManager.installedFromMarket(weakActivity)) {
            UpdateManager.startUpdateTask(weakActivity, urlString, appIdentifier, listener);
        }
    }

    public static void unregister() {
        if (updateTask != null) {
            updateTask.cancel(true);
            updateTask.detach();
            updateTask = null;
        }
        lastListener = null;
    }

    private static boolean checkExpiryDate(WeakReference<Activity> weakActivity, UpdateManagerListener listener) {
        boolean result = false;
        boolean handle = false;
        if (listener != null) {
            Date expiryDate = listener.getExpiryDate();
            boolean bl = result = expiryDate != null && new Date().compareTo(expiryDate) > 0;
            if (result) {
                handle = listener.onBuildExpired();
            }
        }
        if (result && handle) {
            UpdateManager.startExpiryInfoIntent(weakActivity);
        }
        return result;
    }

    private static boolean installedFromMarket(WeakReference<Activity> weakActivity) {
        boolean result = false;
        Activity activity = (Activity)weakActivity.get();
        if (activity != null) {
            try {
                String installer = activity.getPackageManager().getInstallerPackageName(activity.getPackageName());
                result = installer != null && !installer.isEmpty();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private static void startExpiryInfoIntent(WeakReference<Activity> weakActivity) {
        Activity activity;
        if (weakActivity != null && (activity = (Activity)weakActivity.get()) != null) {
            activity.finish();
            Intent intent = new Intent((Context)activity, ExpiryInfoActivity.class);
            intent.addFlags(0x14000000);
            activity.startActivity(intent);
        }
    }

    private static void startUpdateTask(WeakReference<Activity> weakActivity, String urlString, String appIdentifier, UpdateManagerListener listener) {
        if (updateTask == null || updateTask.getStatus() == AsyncTask.Status.FINISHED) {
            updateTask = new CheckUpdateTask(weakActivity, urlString, appIdentifier, listener);
            updateTask.execute(new String[0]);
        } else {
            updateTask.attach(weakActivity);
        }
    }

    @TargetApi(value=11)
    private static boolean dialogShown(WeakReference<Activity> weakActivity) {
        Activity activity;
        if (weakActivity != null && (activity = (Activity)weakActivity.get()) != null) {
            Fragment existingFragment = activity.getFragmentManager().findFragmentByTag("hockey_update_dialog");
            return existingFragment != null;
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    public static Boolean fragmentsSupported() {
        try {
            return Build.VERSION.SDK_INT >= 11 && Fragment.class != null;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    public static Boolean runsOnTablet(WeakReference<Activity> weakActivity) {
        Activity activity;
        if (weakActivity != null && (activity = (Activity)weakActivity.get()) != null) {
            Configuration configuration = activity.getResources().getConfiguration();
            return (configuration.screenLayout & 0xF) == 3 || (configuration.screenLayout & 0xF) == 4;
        }
        return false;
    }

    public static UpdateManagerListener getLastListener() {
        return lastListener;
    }
}

