/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.tasks;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import net.hockeyapp.android.Strings;
import net.hockeyapp.android.listeners.DownloadFileListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadFileTask
extends AsyncTask<String, Integer, Boolean> {
    private Context context;
    private DownloadFileListener notifier;
    private String urlString;
    private String filename;
    private String filePath;
    private ProgressDialog progressDialog;

    public DownloadFileTask(Context context, String urlString, DownloadFileListener notifier) {
        this.context = context;
        this.urlString = urlString;
        this.filename = UUID.randomUUID() + ".apk";
        this.filePath = Environment.getExternalStorageDirectory().getAbsolutePath() + "/Download";
        this.notifier = notifier;
    }

    public void attach(Context context) {
        this.context = context;
    }

    public void detach() {
        this.context = null;
        this.progressDialog = null;
    }

    protected Boolean doInBackground(String ... args) {
        try {
            URL url = new URL(this.getURLString());
            URLConnection connection = this.createConnection(url);
            connection.connect();
            int lenghtOfFile = connection.getContentLength();
            File dir = new File(this.filePath);
            boolean result = dir.mkdirs();
            if (!result && !dir.exists()) {
                throw new IOException("Could not create the dir(s):" + dir.getAbsolutePath());
            }
            File file = new File(dir, this.filename);
            BufferedInputStream input = new BufferedInputStream(connection.getInputStream());
            FileOutputStream output = new FileOutputStream(file);
            byte[] data = new byte[1024];
            int count = 0;
            long total = 0L;
            while ((count = ((InputStream)input).read(data)) != -1) {
                this.publishProgress(new Integer[]{(int)((total += (long)count) * 100L / (long)lenghtOfFile)});
                ((OutputStream)output).write(data, 0, count);
            }
            output.flush();
            ((OutputStream)output).close();
            ((InputStream)input).close();
            return total > 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected URLConnection createConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("connection", "close");
        return connection;
    }

    protected void onProgressUpdate(Integer ... args) {
        try {
            if (this.progressDialog == null) {
                this.progressDialog = new ProgressDialog(this.context);
                this.progressDialog.setProgressStyle(1);
                this.progressDialog.setMessage((CharSequence)"Loading...");
                this.progressDialog.setCancelable(false);
                this.progressDialog.show();
            }
            this.progressDialog.setProgress(args[0].intValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onPostExecute(Boolean result) {
        if (this.progressDialog != null) {
            try {
                this.progressDialog.dismiss();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (result.booleanValue()) {
            this.notifier.downloadSuccessful(this);
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.fromFile((File)new File(this.filePath, this.filename)), "application/vnd.android.package-archive");
            intent.setFlags(0x10000000);
            this.context.startActivity(intent);
        } else {
            try {
                AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
                builder.setTitle((CharSequence)Strings.get(this.notifier, 4));
                builder.setMessage((CharSequence)Strings.get(this.notifier, 5));
                builder.setNegativeButton((CharSequence)Strings.get(this.notifier, 6), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        DownloadFileTask.this.notifier.downloadFailed(DownloadFileTask.this, false);
                    }
                });
                builder.setPositiveButton((CharSequence)Strings.get(this.notifier, 7), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        DownloadFileTask.this.notifier.downloadFailed(DownloadFileTask.this, true);
                    }
                });
                builder.create().show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getURLString() {
        return this.urlString + "&type=apk";
    }
}

