/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.tasks;

import android.app.ProgressDialog;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import net.hockeyapp.android.Constants;
import net.hockeyapp.android.utils.ConnectionManager;
import net.hockeyapp.android.utils.Util;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendFeedbackTask
extends AsyncTask<Void, Void, HashMap<String, String>> {
    private Context context;
    private Handler handler;
    private String urlString;
    private String name;
    private String email;
    private String subject;
    private String text;
    private String token;
    private boolean isFetchMessages;
    private ProgressDialog progressDialog;

    public SendFeedbackTask(Context context, String urlString, String name, String email, String subject, String text, String token, Handler handler, boolean isFetchMessages) {
        this.context = context;
        this.urlString = urlString;
        this.name = name;
        this.email = email;
        this.subject = subject;
        this.text = text;
        this.token = token;
        this.handler = handler;
        this.isFetchMessages = isFetchMessages;
        if (context != null) {
            Constants.loadFromContext(context);
        }
    }

    public void attach(Context context) {
        this.context = context;
    }

    public void detach() {
        this.context = null;
        this.progressDialog = null;
    }

    protected void onPreExecute() {
        String loadingMessage = "Sending feedback..";
        if (this.isFetchMessages) {
            loadingMessage = "Retrieving discussions...";
        }
        if (this.progressDialog == null || !this.progressDialog.isShowing()) {
            this.progressDialog = ProgressDialog.show((Context)this.context, (CharSequence)"", (CharSequence)loadingMessage, (boolean)true, (boolean)false);
        }
    }

    protected HashMap<String, String> doInBackground(Void ... args) {
        HttpClient httpclient = ConnectionManager.getInstance().getHttpClient();
        if (this.isFetchMessages && this.token != null) {
            return this.doGet(httpclient);
        }
        if (!this.isFetchMessages) {
            return this.doPostPut(httpclient);
        }
        return null;
    }

    protected void onPostExecute(HashMap<String, String> result) {
        if (this.progressDialog != null) {
            try {
                this.progressDialog.dismiss();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.handler != null) {
            Message msg = new Message();
            Bundle bundle = new Bundle();
            bundle.putString("request_type", result.get("type"));
            bundle.putString("feedback_response", result.get("response"));
            bundle.putString("feedback_status", result.get("status"));
            msg.setData(bundle);
            this.handler.sendMessage(msg);
        }
    }

    private HashMap<String, String> doPostPut(HttpClient httpClient) {
        try {
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            nameValuePairs.add(new BasicNameValuePair("name", this.name));
            nameValuePairs.add(new BasicNameValuePair("email", this.email));
            nameValuePairs.add(new BasicNameValuePair("subject", this.subject));
            nameValuePairs.add(new BasicNameValuePair("text", this.text));
            nameValuePairs.add(new BasicNameValuePair("bundle_identifier", Constants.APP_PACKAGE));
            nameValuePairs.add(new BasicNameValuePair("bundle_short_version", Constants.APP_VERSION_NAME));
            nameValuePairs.add(new BasicNameValuePair("bundle_version", Constants.APP_VERSION));
            nameValuePairs.add(new BasicNameValuePair("os_version", Constants.ANDROID_VERSION));
            nameValuePairs.add(new BasicNameValuePair("oem", Constants.PHONE_MANUFACTURER));
            nameValuePairs.add(new BasicNameValuePair("model", Constants.PHONE_MODEL));
            UrlEncodedFormEntity form = new UrlEncodedFormEntity(nameValuePairs, "UTF-8");
            form.setContentEncoding("UTF-8");
            HttpPost httpPost = null;
            HttpPut httpPut = null;
            if (this.token != null) {
                this.urlString = this.urlString + this.token + "/";
                httpPut = new HttpPut(this.urlString);
            } else {
                httpPost = new HttpPost(this.urlString);
            }
            HttpResponse response = null;
            if (httpPut != null) {
                httpPut.setEntity((HttpEntity)form);
                response = httpClient.execute(httpPut);
            } else if (httpPost != null) {
                httpPost.setEntity((HttpEntity)form);
                response = httpClient.execute((HttpUriRequest)httpPost);
            }
            if (response != null) {
                HttpEntity resEntity = response.getEntity();
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("type", "send");
                result.put("response", EntityUtils.toString((HttpEntity)resEntity));
                result.put("status", "" + response.getStatusLine().getStatusCode());
                return result;
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private HashMap<String, String> doGet(HttpClient httpClient) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.urlString + Util.encodeParam(this.token));
        HttpGet httpGet = new HttpGet(sb.toString());
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity responseEntity = response.getEntity();
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("type", "fetch");
            result.put("response", EntityUtils.toString((HttpEntity)responseEntity));
            result.put("status", "" + response.getStatusLine().getStatusCode());
            return result;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

