/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import net.hockeyapp.android.UpdateInfoListener;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VersionHelper {
    ArrayList<JSONObject> sortedVersions;
    JSONObject newest;
    UpdateInfoListener listener;

    public VersionHelper(String infoJSON, UpdateInfoListener listener) {
        this.listener = listener;
        this.loadVersions(infoJSON);
        this.sortVersions();
    }

    private void loadVersions(String infoJSON) {
        this.newest = new JSONObject();
        try {
            JSONArray versions = new JSONArray(infoJSON);
            this.sortedVersions = new ArrayList();
            int versionCode = this.listener.getCurrentVersionCode();
            for (int index = 0; index < versions.length(); ++index) {
                JSONObject entry = versions.getJSONObject(index);
                if (entry.getInt("version") > versionCode) {
                    this.newest = entry;
                    versionCode = entry.getInt("version");
                }
                this.sortedVersions.add(entry);
            }
        }
        catch (JSONException je) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void sortVersions() {
        Collections.sort(this.sortedVersions, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject object1, JSONObject object2) {
                try {
                    if (object1.getInt("version") > object2.getInt("version")) {
                        return 0;
                    }
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                return 0;
            }
        });
    }

    public String getVersionString() {
        return VersionHelper.failSafeGetStringFromJSON(this.newest, "shortversion", "") + " (" + VersionHelper.failSafeGetStringFromJSON(this.newest, "version", "") + ")";
    }

    public String getFileInfoString() {
        int appSize = VersionHelper.failSafeGetIntFromJSON(this.newest, "appsize", 0);
        long timestamp = VersionHelper.failSafeGetIntFromJSON(this.newest, "timestamp", 0);
        Date date = new Date(timestamp * 1000L);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        return dateFormat.format(date) + " - " + String.format("%.2f", Float.valueOf((float)appSize / 1024.0f / 1024.0f)) + " MB";
    }

    private static String failSafeGetStringFromJSON(JSONObject json, String name, String defaultValue) {
        try {
            return json.getString(name);
        }
        catch (JSONException e) {
            return defaultValue;
        }
    }

    private static int failSafeGetIntFromJSON(JSONObject json, String name, int defaultValue) {
        try {
            return json.getInt(name);
        }
        catch (JSONException e) {
            return defaultValue;
        }
    }

    public String getReleaseNotes(boolean showRestore) {
        StringBuilder result = new StringBuilder();
        result.append("<html>");
        result.append("<body style='padding: 0px 0px 20px 0px'>");
        int count = 0;
        for (JSONObject version : this.sortedVersions) {
            if (count > 0) {
                result.append(this.getSeparator());
                if (showRestore) {
                    result.append(this.getRestoreButton(count, version));
                }
            }
            result.append(this.getVersionLine(count, version));
            result.append(this.getVersionNotes(count, version));
            ++count;
        }
        result.append("</body>");
        result.append("</html>");
        return result.toString();
    }

    private Object getSeparator() {
        return "<hr style='border-top: 1px solid #c8c8c8; border-bottom: 0px; margin: 40px 10px 0px 10px;' />";
    }

    private String getRestoreButton(int count, JSONObject version) {
        StringBuilder result = new StringBuilder();
        String versionID = this.getVersionID(version);
        if (versionID.length() > 0) {
            result.append("<a href='restore:" + versionID + "'  style='background: #c8c8c8; color: #000; display: block; float: right; padding: 7px; margin: 0px 10px 10px; text-decoration: none;'>Restore</a>");
        }
        return result.toString();
    }

    private String getVersionID(JSONObject version) {
        String versionID = "";
        try {
            versionID = version.getString("id");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return versionID;
    }

    private String getVersionLine(int count, JSONObject version) {
        StringBuilder result = new StringBuilder();
        int versionCode = this.getVersionCode(version);
        String versionName = this.getVersionName(version);
        result.append("<div style='padding: 20px 10px 10px;'><strong>");
        if (count == 0) {
            result.append("Newest version:");
        } else {
            int currentVersionCode = this.listener.getCurrentVersionCode();
            result.append("Version " + versionName + " (" + versionCode + "): " + (versionCode == currentVersionCode ? "[INSTALLED]" : ""));
        }
        result.append("</strong></div>");
        return result.toString();
    }

    private int getVersionCode(JSONObject version) {
        int versionCode = 0;
        try {
            versionCode = version.getInt("version");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return versionCode;
    }

    private String getVersionName(JSONObject version) {
        String versionName = "";
        try {
            versionName = version.getString("shortversion");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return versionName;
    }

    private String getVersionNotes(int count, JSONObject version) {
        StringBuilder result = new StringBuilder();
        String notes = VersionHelper.failSafeGetStringFromJSON(version, "notes", "");
        result.append("<div style='padding: 0px 10px;'>");
        if (notes.trim().length() == 0) {
            result.append("<em>No information.</em>");
        } else {
            result.append(notes);
        }
        result.append("</div>");
        return result.toString();
    }
}

