/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.views;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import net.hockeyapp.android.utils.ViewHelper;

public class UpdateView
extends RelativeLayout {
    public static final int HEADER_VIEW_ID = 4097;
    public static final int NAME_LABEL_ID = 4098;
    public static final int VERSION_LABEL_ID = 4099;
    public static final int UPDATE_BUTTON_ID = 4100;
    public static final int WEB_VIEW_ID = 4101;
    protected RelativeLayout headerView = null;
    protected boolean layoutHorizontally = false;
    protected boolean limitHeight = false;

    public UpdateView(Context context) {
        this(context, true);
    }

    public UpdateView(Context context, AttributeSet attrs) {
        this(context, true, false);
    }

    public UpdateView(Context context, boolean allowHorizontalLayout) {
        this(context, true, false);
    }

    public UpdateView(Context context, boolean allowHorizontalLayout, boolean limitHeight) {
        super(context);
        if (allowHorizontalLayout) {
            this.setLayoutHorizontally(context);
        } else {
            this.layoutHorizontally = false;
        }
        this.limitHeight = limitHeight;
        this.loadLayoutParams(context);
        this.loadHeaderView(context);
        this.loadWebView(context);
        this.loadShadow(this.headerView, context);
    }

    private void setLayoutHorizontally(Context context) {
        int orientation = this.getResources().getConfiguration().orientation;
        this.layoutHorizontally = orientation == 2;
    }

    private void loadLayoutParams(Context context) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        this.setBackgroundColor(-1);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void loadHeaderView(Context context) {
        this.headerView = new RelativeLayout(context);
        this.headerView.setId(4097);
        RelativeLayout.LayoutParams params = null;
        if (this.layoutHorizontally) {
            params = new RelativeLayout.LayoutParams((int)TypedValue.applyDimension((int)1, (float)250.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()), -1);
            params.addRule(9, -1);
            this.headerView.setPadding(0, 0, 0, 0);
        } else {
            params = new RelativeLayout.LayoutParams(-1, -2);
            this.headerView.setPadding(0, 0, 0, (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        }
        this.headerView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.headerView.setBackgroundColor(Color.rgb((int)230, (int)236, (int)239));
        this.loadTitleLabel(this.headerView, context);
        this.loadVersionLabel(this.headerView, context);
        this.loadUpdateButton(this.headerView, context);
        this.addView((View)this.headerView);
    }

    private void loadTitleLabel(RelativeLayout headerView, Context context) {
        TextView textView = new TextView(context);
        textView.setId(4098);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        int margin = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.setMargins(margin, margin, margin, 0);
        textView.setLayoutParams((ViewGroup.LayoutParams)params);
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setShadowLayer(1.0f, 0.0f, 1.0f, -1);
        textView.setSingleLine(true);
        textView.setTextColor(-16777216);
        textView.setTextSize(2, 20.0f);
        textView.setTypeface(null, 1);
        headerView.addView((View)textView);
    }

    private void loadVersionLabel(RelativeLayout headerView, Context context) {
        TextView textView = new TextView(context);
        textView.setId(4099);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        int marginSide = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        int marginTop = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.setMargins(marginSide, marginTop, marginSide, 0);
        params.addRule(3, 4098);
        textView.setLayoutParams((ViewGroup.LayoutParams)params);
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setShadowLayer(1.0f, 0.0f, 1.0f, -1);
        textView.setLines(2);
        textView.setLineSpacing(0.0f, 1.1f);
        textView.setTextColor(-16777216);
        textView.setTextSize(2, 16.0f);
        textView.setTypeface(null, 1);
        headerView.addView((View)textView);
    }

    private void loadUpdateButton(RelativeLayout headerView, Context context) {
        Button button = new Button(context);
        button.setId(4100);
        int margin = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        int width = (int)TypedValue.applyDimension((int)1, (float)120.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(width, -2);
        params.setMargins(margin, margin, margin, margin);
        params.addRule(9, -1);
        params.addRule(3, 4099);
        button.setLayoutParams((ViewGroup.LayoutParams)params);
        button.setBackgroundDrawable(this.getButtonSelector());
        button.setText((CharSequence)"Update");
        button.setTextColor(-1);
        button.setTextSize(2, 16.0f);
        headerView.addView((View)button);
    }

    private Drawable getButtonSelector() {
        StateListDrawable drawable = new StateListDrawable();
        drawable.addState(new int[]{-16842919}, (Drawable)new ColorDrawable(-16777216));
        drawable.addState(new int[]{-16842919, 16842908}, (Drawable)new ColorDrawable(-12303292));
        drawable.addState(new int[]{16842919}, (Drawable)new ColorDrawable(-7829368));
        return drawable;
    }

    private void loadShadow(RelativeLayout headerView, Context context) {
        int height = (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = null;
        ImageView topShadowView = new ImageView(context);
        if (this.layoutHorizontally) {
            params = new RelativeLayout.LayoutParams(1, -1);
            params.addRule(11, -1);
            topShadowView.setBackgroundDrawable((Drawable)new ColorDrawable(-16777216));
        } else {
            params = new RelativeLayout.LayoutParams(-1, height);
            params.addRule(10, -1);
            topShadowView.setBackgroundDrawable(ViewHelper.getGradient());
        }
        topShadowView.setLayoutParams((ViewGroup.LayoutParams)params);
        headerView.addView((View)topShadowView);
        ImageView bottomShadowView = new ImageView(context);
        params = new RelativeLayout.LayoutParams(-1, height);
        if (this.layoutHorizontally) {
            params.addRule(10, -1);
        } else {
            params.addRule(3, 4097);
        }
        bottomShadowView.setLayoutParams((ViewGroup.LayoutParams)params);
        bottomShadowView.setBackgroundDrawable(ViewHelper.getGradient());
        this.addView((View)bottomShadowView);
    }

    private void loadWebView(Context context) {
        WebView webView = new WebView(context);
        webView.setId(4101);
        int height = (int)TypedValue.applyDimension((int)1, (float)400.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, this.limitHeight ? height : -1);
        if (this.layoutHorizontally) {
            params.addRule(1, 4097);
        } else {
            params.addRule(3, 4097);
        }
        params.setMargins(0, 0, 0, 0);
        webView.setLayoutParams((ViewGroup.LayoutParams)params);
        webView.setBackgroundColor(-1);
        this.addView((View)webView);
    }
}

