/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.asn1;

import info.guardianproject.bouncycastle.asn1.ASN1InputStream;
import info.guardianproject.bouncycastle.asn1.DEREncodable;
import info.guardianproject.bouncycastle.asn1.DERObject;
import info.guardianproject.bouncycastle.asn1.DEROutputStream;
import java.io.IOException;

public abstract class ASN1Object
extends DERObject {
    public static ASN1Object fromByteArray(byte[] data) throws IOException {
        ASN1InputStream aIn = new ASN1InputStream(data);
        try {
            return (ASN1Object)aIn.readObject();
        }
        catch (ClassCastException e) {
            throw new IOException("cannot recognise object in stream");
        }
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof DEREncodable && this.asn1Equals(((DEREncodable)o).getDERObject());
    }

    @Override
    public abstract int hashCode();

    @Override
    abstract void encode(DEROutputStream var1) throws IOException;

    abstract boolean asn1Equals(DERObject var1);
}

