/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.asn1;

import info.guardianproject.bouncycastle.asn1.ASN1ApplicationSpecificParser;
import info.guardianproject.bouncycastle.asn1.ASN1ParsingException;
import info.guardianproject.bouncycastle.asn1.ASN1StreamParser;
import info.guardianproject.bouncycastle.asn1.BERApplicationSpecific;
import info.guardianproject.bouncycastle.asn1.DEREncodable;
import info.guardianproject.bouncycastle.asn1.DERObject;
import java.io.IOException;

public class BERApplicationSpecificParser
implements ASN1ApplicationSpecificParser {
    private final int tag;
    private final ASN1StreamParser parser;

    BERApplicationSpecificParser(int tag, ASN1StreamParser parser) {
        this.tag = tag;
        this.parser = parser;
    }

    @Override
    public DEREncodable readObject() throws IOException {
        return this.parser.readObject();
    }

    @Override
    public DERObject getLoadedObject() throws IOException {
        return new BERApplicationSpecific(this.tag, this.parser.readVector());
    }

    @Override
    public DERObject getDERObject() {
        try {
            return this.getLoadedObject();
        }
        catch (IOException e) {
            throw new ASN1ParsingException(e.getMessage(), e);
        }
    }
}

