/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.asn1;

import info.guardianproject.bouncycastle.asn1.ASN1Object;
import info.guardianproject.bouncycastle.asn1.ASN1OctetString;
import info.guardianproject.bouncycastle.asn1.ASN1TaggedObject;
import info.guardianproject.bouncycastle.asn1.DERObject;
import info.guardianproject.bouncycastle.asn1.DEROutputStream;
import info.guardianproject.bouncycastle.asn1.DERString;
import java.io.IOException;

public class DERGeneralString
extends ASN1Object
implements DERString {
    private String string;

    public static DERGeneralString getInstance(Object obj) {
        if (obj == null || obj instanceof DERGeneralString) {
            return (DERGeneralString)obj;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERGeneralString getInstance(ASN1TaggedObject obj, boolean explicit) {
        DERObject o = obj.getObject();
        if (explicit || o instanceof DERGeneralString) {
            return DERGeneralString.getInstance(o);
        }
        return new DERGeneralString(((ASN1OctetString)o).getOctets());
    }

    public DERGeneralString(byte[] string) {
        char[] cs = new char[string.length];
        int i = 0;
        while (i != cs.length) {
            cs[i] = (char)(string[i] & 0xFF);
            ++i;
        }
        this.string = new String(cs);
    }

    public DERGeneralString(String string) {
        this.string = string;
    }

    @Override
    public String getString() {
        return this.string;
    }

    public String toString() {
        return this.string;
    }

    public byte[] getOctets() {
        char[] cs = this.string.toCharArray();
        byte[] bs = new byte[cs.length];
        int i = 0;
        while (i != cs.length) {
            bs[i] = (byte)cs[i];
            ++i;
        }
        return bs;
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(27, this.getOctets());
    }

    @Override
    public int hashCode() {
        return this.getString().hashCode();
    }

    @Override
    boolean asn1Equals(DERObject o) {
        if (!(o instanceof DERGeneralString)) {
            return false;
        }
        DERGeneralString s = (DERGeneralString)o;
        return this.getString().equals(s.getString());
    }
}

