/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.asn1.cmp;

import info.guardianproject.bouncycastle.asn1.ASN1Encodable;
import info.guardianproject.bouncycastle.asn1.ASN1EncodableVector;
import info.guardianproject.bouncycastle.asn1.ASN1Sequence;
import info.guardianproject.bouncycastle.asn1.ASN1TaggedObject;
import info.guardianproject.bouncycastle.asn1.DERObject;
import info.guardianproject.bouncycastle.asn1.DERSequence;
import info.guardianproject.bouncycastle.asn1.DERTaggedObject;
import info.guardianproject.bouncycastle.asn1.cmp.CMPCertificate;
import info.guardianproject.bouncycastle.asn1.cmp.CertResponse;

public class CertRepMessage
extends ASN1Encodable {
    private ASN1Sequence caPubs;
    private ASN1Sequence response;

    private CertRepMessage(ASN1Sequence seq) {
        int index = 0;
        if (seq.size() > 1) {
            this.caPubs = ASN1Sequence.getInstance((ASN1TaggedObject)seq.getObjectAt(index++), true);
        }
        this.response = ASN1Sequence.getInstance(seq.getObjectAt(index));
    }

    public static CertRepMessage getInstance(Object o) {
        if (o instanceof CertRepMessage) {
            return (CertRepMessage)o;
        }
        if (o instanceof ASN1Sequence) {
            return new CertRepMessage((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public CertRepMessage(CMPCertificate[] caPubs, CertResponse[] response) {
        int i;
        ASN1EncodableVector v;
        if (response == null) {
            throw new IllegalArgumentException("'response' cannot be null");
        }
        if (caPubs != null) {
            v = new ASN1EncodableVector();
            i = 0;
            while (i < caPubs.length) {
                v.add(caPubs[i]);
                ++i;
            }
            this.caPubs = new DERSequence(v);
        }
        v = new ASN1EncodableVector();
        i = 0;
        while (i < response.length) {
            v.add(response[i]);
            ++i;
        }
        this.response = new DERSequence(v);
    }

    public CMPCertificate[] getCaPubs() {
        if (this.caPubs == null) {
            return null;
        }
        CMPCertificate[] results = new CMPCertificate[this.caPubs.size()];
        int i = 0;
        while (i != results.length) {
            results[i] = CMPCertificate.getInstance(this.caPubs.getObjectAt(i));
            ++i;
        }
        return results;
    }

    public CertResponse[] getResponse() {
        CertResponse[] results = new CertResponse[this.response.size()];
        int i = 0;
        while (i != results.length) {
            results[i] = CertResponse.getInstance(this.response.getObjectAt(i));
            ++i;
        }
        return results;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.caPubs != null) {
            v.add(new DERTaggedObject(true, 1, this.caPubs));
        }
        v.add(this.response);
        return new DERSequence(v);
    }
}

