/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.asn1.ocsp;

import info.guardianproject.bouncycastle.asn1.ASN1Encodable;
import info.guardianproject.bouncycastle.asn1.ASN1EncodableVector;
import info.guardianproject.bouncycastle.asn1.ASN1Sequence;
import info.guardianproject.bouncycastle.asn1.ASN1TaggedObject;
import info.guardianproject.bouncycastle.asn1.DERInteger;
import info.guardianproject.bouncycastle.asn1.DERObject;
import info.guardianproject.bouncycastle.asn1.DERSequence;
import info.guardianproject.bouncycastle.asn1.DERTaggedObject;
import info.guardianproject.bouncycastle.asn1.x509.GeneralName;
import info.guardianproject.bouncycastle.asn1.x509.X509Extensions;

public class TBSRequest
extends ASN1Encodable {
    private static final DERInteger V1 = new DERInteger(0);
    DERInteger version;
    GeneralName requestorName;
    ASN1Sequence requestList;
    X509Extensions requestExtensions;
    boolean versionSet;

    public TBSRequest(GeneralName requestorName, ASN1Sequence requestList, X509Extensions requestExtensions) {
        this.version = V1;
        this.requestorName = requestorName;
        this.requestList = requestList;
        this.requestExtensions = requestExtensions;
    }

    public TBSRequest(ASN1Sequence seq) {
        int index = 0;
        if (seq.getObjectAt(0) instanceof ASN1TaggedObject) {
            ASN1TaggedObject o = (ASN1TaggedObject)seq.getObjectAt(0);
            if (o.getTagNo() == 0) {
                this.versionSet = true;
                this.version = DERInteger.getInstance((ASN1TaggedObject)seq.getObjectAt(0), true);
                ++index;
            } else {
                this.version = V1;
            }
        } else {
            this.version = V1;
        }
        if (seq.getObjectAt(index) instanceof ASN1TaggedObject) {
            this.requestorName = GeneralName.getInstance((ASN1TaggedObject)seq.getObjectAt(index++), true);
        }
        this.requestList = (ASN1Sequence)seq.getObjectAt(index++);
        if (seq.size() == index + 1) {
            this.requestExtensions = X509Extensions.getInstance((ASN1TaggedObject)seq.getObjectAt(index), true);
        }
    }

    public static TBSRequest getInstance(ASN1TaggedObject obj, boolean explicit) {
        return TBSRequest.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static TBSRequest getInstance(Object obj) {
        if (obj == null || obj instanceof TBSRequest) {
            return (TBSRequest)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new TBSRequest((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public GeneralName getRequestorName() {
        return this.requestorName;
    }

    public ASN1Sequence getRequestList() {
        return this.requestList;
    }

    public X509Extensions getRequestExtensions() {
        return this.requestExtensions;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (!this.version.equals(V1) || this.versionSet) {
            v.add(new DERTaggedObject(true, 0, this.version));
        }
        if (this.requestorName != null) {
            v.add(new DERTaggedObject(true, 1, this.requestorName));
        }
        v.add(this.requestList);
        if (this.requestExtensions != null) {
            v.add(new DERTaggedObject(true, 2, this.requestExtensions));
        }
        return new DERSequence(v);
    }
}

