/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.asn1.x500;

import info.guardianproject.bouncycastle.asn1.ASN1Encodable;
import info.guardianproject.bouncycastle.asn1.ASN1ObjectIdentifier;
import info.guardianproject.bouncycastle.asn1.x500.AttributeTypeAndValue;
import info.guardianproject.bouncycastle.asn1.x500.RDN;
import info.guardianproject.bouncycastle.asn1.x500.X500Name;
import info.guardianproject.bouncycastle.asn1.x500.X500NameStyle;
import java.util.Vector;

public class X500NameBuilder {
    private X500NameStyle template;
    private Vector rdns = new Vector();

    public X500NameBuilder(X500NameStyle template) {
        this.template = template;
    }

    public X500NameBuilder addRDN(ASN1ObjectIdentifier oid, String value) {
        this.addRDN(oid, this.template.stringToValue(oid, value));
        return this;
    }

    public X500NameBuilder addRDN(ASN1ObjectIdentifier oid, ASN1Encodable value) {
        this.rdns.addElement(new RDN(oid, value));
        return this;
    }

    public X500NameBuilder addRDN(AttributeTypeAndValue attrTAndV) {
        this.rdns.addElement(new RDN(attrTAndV));
        return this;
    }

    public X500NameBuilder addMultiValuedRDN(ASN1ObjectIdentifier[] oids, String[] values) {
        ASN1Encodable[] vals = new ASN1Encodable[values.length];
        int i = 0;
        while (i != vals.length) {
            vals[i] = this.template.stringToValue(oids[i], values[i]);
            ++i;
        }
        return this.addMultiValuedRDN(oids, vals);
    }

    public X500NameBuilder addMultiValuedRDN(ASN1ObjectIdentifier[] oids, ASN1Encodable[] values) {
        AttributeTypeAndValue[] avs = new AttributeTypeAndValue[oids.length];
        int i = 0;
        while (i != oids.length) {
            avs[i] = new AttributeTypeAndValue(oids[i], values[i]);
            ++i;
        }
        return this.addMultiValuedRDN(avs);
    }

    public X500NameBuilder addMultiValuedRDN(AttributeTypeAndValue[] attrTAndVs) {
        this.rdns.addElement(new RDN(attrTAndVs));
        return this;
    }

    public X500Name build() {
        RDN[] vals = new RDN[this.rdns.size()];
        int i = 0;
        while (i != vals.length) {
            vals[i] = (RDN)this.rdns.elementAt(i);
            ++i;
        }
        return new X500Name(this.template, vals);
    }
}

